package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.AppSignOperatingPositionDto;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/12/5.
 */
@AdvancedFeignClient
public interface RemoteAppSignOperatingPositionService {
    /**
     * 插入操作
     * @param dto 数据表对应的实体类
     * @return
     */
    long insert(AppSignOperatingPositionDto dto);
    /**
     * 根据主键删除对应数据
     * @param id
     * @return
     */
    int deleteById(Long id);
    /**
     * 根据主键更新对应数据条目
     * @param dto
     * @return
     */
    int updateById(AppSignOperatingPositionDto dto);
    /**
     * 根据主键更新对应数据条目，如果entity数据域为null则不更新对应数据域
     * @param dto
     * @return
     */
    int updateByIdSelective(AppSignOperatingPositionDto dto);

    /**
     * 查询
     * @param id
     * @return
     */
    AppSignOperatingPositionDto findById(Long id);

    /**
     * 查询
     * @param appId
     * @param actId 签到活动ID
     * @return
     */
    List<AppSignOperatingPositionDto> findByAppIdAndActId(Long appId, Long actId);

    /**
     * 查询
     * @param appId
     * @param actId
     * @param modelId
     * @return
     */
    AppSignOperatingPositionDto findByAppIdAndActIdAndModelId(Long appId, Long actId, Long modelId);
}
