package cn.com.duiba.sign.center.api.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * Created by 歪大哥😁 on 2019-09-04.
 */
public class DateFormatUtils {

    private static final ZoneId ZONE_ID = ZoneId.systemDefault();

    private static final String MONTH_SUFFIX = "01";

    private static DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern("yyyyMM");

    private static DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyyMMdd");

    public static String date2YYYYMM(Date date) {
        return YYYY_MM.format(date.toInstant().atZone(ZONE_ID).toLocalDateTime());
    }

    public static Date YYYYMM2Date(String month) {
        return YYYYMMDD2Date(month + MONTH_SUFFIX);
    }

    public static String date2YYYYMMDD(Date date) {
        return YYYY_MM_DD.format(date.toInstant().atZone(ZONE_ID).toLocalDateTime());
    }

    public static Date YYYYMMDD2Date(String date) {
        return Date.from(LocalDate.parse(date, YYYY_MM_DD).atTime(0,0).atZone(ZONE_ID).toInstant());
    }

    private DateFormatUtils() {
        // do nothing
    }

}
