package cn.com.duiba.sign.center.api.params;

import cn.com.duiba.sign.center.api.enums.signcomponent.SignStatusEnum;
import com.alibaba.fastjson.JSONObject;

import javax.annotation.CheckForNull;
import java.io.Serializable;
import java.util.Map;

/**
 * Created by 歪大哥😁 on 2019-08-28.
 */
public class SignComponentRewardParam implements Serializable {
    private static final long serialVersionUID = -2218575616491916307L;

    private Integer val;

    private Map<Integer, Integer> detail;

    private String errorMsg;

    public Integer getVal() {
        return val;
    }

    public void setVal(Integer val) {
        this.val = val;
    }

    public Map<Integer, Integer> getDetail() {
        return detail;
    }

    public void setDetail(Map<Integer, Integer> detail) {
        this.detail = detail;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String serialize2JsonString() {
        return JSONObject.toJSONString(this);
    }

    @CheckForNull
    public static SignComponentRewardParam deserializeFromJsonString(String jsonString) {
        try {
            return JSONObject.parseObject(jsonString, SignComponentRewardParam.class);
        } catch (Exception e) {
            return null;
        }
    }

}
