package cn.com.duiba.sign.center.api.remoteservice.signcomponent;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.signcomponent.SignComponentLogDto;
import cn.com.duiba.sign.center.api.params.SignComponentRewardParam;

import javax.annotation.CheckForNull;
import java.util.List;

/**
 * Created by 歪大哥😁 on 2019-08-29.
 */
@AdvancedFeignClient
public interface RemoteSignComponentLogService {

    /** 新增一条签到记录 */
    Long insert(SignComponentLogDto log) throws BizException;

    /** 根据id查询 */
    SignComponentLogDto selectById(Long id);

    /** 查询最新的一条签到记录 */
    @CheckForNull
    SignComponentLogDto selectNewestOne(Long cid, Long activityId);

    /** 查询一个月的签到记录 */
    List<SignComponentLogDto> selectMonthlyLogs(Long cid, Long activityId, Integer month);

    /** 查询某一天的签到记录 */
    @CheckForNull
    SignComponentLogDto selectOneDayLog(Long cid, Long activityId, Integer day);

    /** 按照时间范围查询 */
    List<SignComponentLogDto> selectLogsByDateRange(Long cid, Long activityId, Integer startDate, Integer endDate);

    /** 更新奖励信息 */
    boolean updateReward(Long id, SignComponentRewardParam credits, SignComponentRewardParam drawCount);

    /** 将签到记录状态变更为发奖结束 */
    boolean updateToSuccess(Long id);

    /** 将签到设置为失败状态 目前只有补签会失败 */
    boolean updateToFail(Long id, String errorMsg);

    /** 将签到设置为处理中状态 目前只有补签失败 后发起再次补签的时候会把状态改成处理中 */
    boolean updateToProcessing(Long id);

    /** 将签到设置为发奖中状态 */
    boolean updateToRewardProcessing(Long id);

    /** 根据补签记录 更新后续签到记录 */
    void doAfterReSign(Long id);

    /**
     * 按时间范围查询签到天数
     * @param cid
     * @param activityId
     * @param startDate
     * @param endDate
     */
    int countByDateRange(Long cid, Long activityId, Integer startDate, Integer endDate);

    /**
     * 根据补签日期，更新后续全部签到记录的连续签到天数，不更新累计签到天数
     */
    void updateConsecutiveCountAfterResign(Long cid, Long activityId, Integer resignDate);
}
