package cn.com.duiba.sign.center.api.dto.signfornew;

import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountTypeEnum;
import cn.com.duiba.api.enums.AppChannelTypeEnum;
import cn.com.duiba.api.enums.RewardWayTypeEnum;
import cn.com.duiba.sign.center.api.dto.SignRewardRuleItemDto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by xiaoxuda on 2019/3/8.
 */
public class SignForNewDto implements Serializable {

    private static final long serialVersionUID = 2308413014285764402L;

    /**id**/
    private Long id;

    /**投放类型，1：app，2：微信**/
    private AppChannelTypeEnum channelType;

    /**标题**/
    private String title;

    /**规则描述**/
    private String intro;

    /**banner图**/
    private String bannerImg;

    /**
     * 缩略图
     */
    private String smallImg;

    /**活动开始时间**/
    private Date startTime;

    /**活动结束时间**/
    private Date endTime;

    /**奖励方式，1：无，2：积分，3：红包，4：积分+红包,5：插件抽奖机会，6：奖品池抽奖机会**/
    private RewardWayTypeEnum rewardType;

    //奖励方式:1:现金红包; 2:虚拟货币
    private Integer rewardSubType;

    /**预算，单位：分**/
    private Long bonusLimit;

    /**预算余额预警阀值，单位：分**/
    private Long balanceWarn;

    /**预警手机号**/
    private String warnPhone;

    /**账户类型，6：总帐户，14：自定义账户**/
    private AccountTypeEnum accType;

    /**所属应用ID**/
    private Long appId;

    /**签到奖励规则配置**/
    private List<SignRewardRuleItemDto> rewardRule;

    /**页面配置**/
    private SignForNewStyleConfDto styleConf;

    /**
     * 删除状态
     */
    private Boolean deleted;

    /**
     * 是否开启
     */
    private Boolean openStatus;

    /**gmtCreate**/
    private Date gmtCreate;

    /**gmtModified**/
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AppChannelTypeEnum getChannelType() {
        return channelType;
    }

    public void setChannelType(AppChannelTypeEnum channelType) {
        this.channelType = channelType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public String getBannerImg() {
        return bannerImg;
    }

    public void setBannerImg(String bannerImg) {
        this.bannerImg = bannerImg;
    }

    public String getSmallImg() {
        return smallImg;
    }

    public void setSmallImg(String smallImg) {
        this.smallImg = smallImg;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public RewardWayTypeEnum getRewardType() {
        return rewardType;
    }

    public void setRewardType(RewardWayTypeEnum rewardType) {
        this.rewardType = rewardType;
    }

    public Long getBonusLimit() {
        return bonusLimit;
    }

    public void setBonusLimit(Long bonusLimit) {
        this.bonusLimit = bonusLimit;
    }

    public Long getBalanceWarn() {
        return balanceWarn;
    }

    public void setBalanceWarn(Long balanceWarn) {
        this.balanceWarn = balanceWarn;
    }

    public String getWarnPhone() {
        return warnPhone;
    }

    public void setWarnPhone(String warnPhone) {
        this.warnPhone = warnPhone;
    }

    public AccountTypeEnum getAccType() {
        return accType;
    }

    public void setAccType(AccountTypeEnum accType) {
        this.accType = accType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public List<SignRewardRuleItemDto> getRewardRule() {
        return rewardRule;
    }

    public void setRewardRule(List<SignRewardRuleItemDto> rewardRule) {
        this.rewardRule = rewardRule;
    }

    public SignForNewStyleConfDto getStyleConf() {
        return styleConf;
    }

    public void setStyleConf(SignForNewStyleConfDto styleConf) {
        this.styleConf = styleConf;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Boolean getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Boolean openStatus) {
        this.openStatus = openStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getRewardSubType() {
        return rewardSubType;
    }

    public void setRewardSubType(Integer rewardSubType) {
        this.rewardSubType = rewardSubType;
    }
}
