package cn.com.duiba.sign.center.api.dto.signtreasure;

import cn.com.duiba.sign.center.api.enums.signtreasure.SignTreasureActStatusEnum;
import cn.com.duiba.sign.center.api.enums.signtreasure.SignTreasureAwardStyleEnum;
import cn.com.duiba.sign.center.api.enums.signtreasure.SignTreasurePhaseStatusEnum;
import cn.com.duiba.sign.center.api.enums.signtreasure.SignTreasureStockWarnTypeEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author chenxiangge
 * @Date 2019/4/29
 */
public class SignTreasureActBackendDto implements Serializable {

    private static final long serialVersionUID = -1010517588167618801L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 入库活动是否已关闭
     */
    private Boolean closeStatus;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 活动开始时间（首期开始时间）
     */
    private Date actStartTime;

    /**
     *  标题
     */
    private String title;

    /**
     * 规则
     */
    private String rule;

    /**
     * 入口缩略图
     */
    private String smallImage;

    /**
     * banner图
     */
    private String bannerImage;

    /**
     * 界面配置
     */
    private String skinConfig;

    /**
     * 展示中奖轮播 0-不支持 1-支持
     */
    private Boolean showWinRecord;

    /**
     * 是否支持积分兑换 0-不支持 1-支持
     */
    private Boolean creditsSupport;

    /**
     * 浮窗
     */
    private String floatingWindow;



    /**
     * 单次兑换消耗积分数量
     */
    private Integer credits;

    /**
     * 购买上限
     */
    private Integer maxPurchaseAmount;

    /**
     * 是否自动续期 0-不续期，1-续期
     */
    private Boolean autoContinue;

    /**
     * 自动续期数
     */
    private Integer autoContinueCount;

    /**
     * 当前期次id
     */
    private Long currentPhaseId;

    /**
     * 当前期次序号
     */
    private Integer currentPayload;

    /**
     * 活动周期
     */
    private Integer activityCycle;

    /**
     * 结束后多久开奖（天数）
     */
    private Integer takePrizeCycle;

    /**
     * （待定）开奖时间 hh:mm格式
     */
    private String takePrizeTimeStr;

    /**
     * 库存预警类型 0-邮箱 1-手机
     */
    private SignTreasureStockWarnTypeEnum stockWarnType;

    /**
     * 库存预警发送方具体信息
     */
    private String stockWarnDetail;

    /**
     * 奖励方式 0-每日签到一个 1-获得连签天数数量
     */
    private SignTreasureAwardStyleEnum awardStyle;

    /**
     * 0-进行中 1-已结束
     */
    private SignTreasureActStatusEnum activityStatus;

    /* --------- 期次信息与赛事信息的分割线  --------- */

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 开奖时间
     */
    private Date takePrizeTime;

    /**
     * 期次号（期次开始时间的年月日格式）
     */
    private String phaseNumber;

    /**
     * 期次状态 期次状态 0-进行中，1-已开奖（期次默认状态即为进行中）
     */
    private SignTreasurePhaseStatusEnum phaseStatus;

    /**
     * 当前期次序号
     */
    private Integer payload;

    /**
     * 当前期次奖项信息
     */
    private List<SignTreasureOptionDto> options;

    /**
     * 开关切换
     * 功能开关集合，通过位运算获取具体开关状态
     * 1。 签到是否免费
     */
    private Integer switchType;

    public String getFloatingWindow() {
        return floatingWindow;
    }

    public void setFloatingWindow(String floatingWindow) {
        this.floatingWindow = floatingWindow;
    }

    public Integer getSwitchType() {
        return switchType;
    }

    public void setSwitchType(Integer switchType) {
        this.switchType = switchType;
    }


    public Boolean getCloseStatus() {
        return closeStatus;
    }

    public void setCloseStatus(Boolean closeStatus) {
        this.closeStatus = closeStatus;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getSkinConfig() {
        return skinConfig;
    }

    public void setSkinConfig(String skinConfig) {
        this.skinConfig = skinConfig;
    }

    public Boolean getShowWinRecord() {
        return showWinRecord;
    }

    public void setShowWinRecord(Boolean showWinRecord) {
        this.showWinRecord = showWinRecord;
    }

    public Boolean getCreditsSupport() {
        return creditsSupport;
    }

    public void setCreditsSupport(Boolean creditsSupport) {
        this.creditsSupport = creditsSupport;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getMaxPurchaseAmount() {
        return maxPurchaseAmount;
    }

    public void setMaxPurchaseAmount(Integer maxPurchaseAmount) {
        this.maxPurchaseAmount = maxPurchaseAmount;
    }

    public Boolean getAutoContinue() {
        return autoContinue;
    }

    public void setAutoContinue(Boolean autoContinue) {
        this.autoContinue = autoContinue;
    }

    public Integer getAutoContinueCount() {
        return autoContinueCount;
    }

    public void setAutoContinueCount(Integer autoContinueCount) {
        this.autoContinueCount = autoContinueCount;
    }

    public Long getCurrentPhaseId() {
        return currentPhaseId;
    }

    public void setCurrentPhaseId(Long currentPhaseId) {
        this.currentPhaseId = currentPhaseId;
    }

    public Integer getCurrentPayload() {
        return currentPayload;
    }

    public void setCurrentPayload(Integer currentPayload) {
        this.currentPayload = currentPayload;
    }

    public Integer getActivityCycle() {
        return activityCycle;
    }

    public void setActivityCycle(Integer activityCycle) {
        this.activityCycle = activityCycle;
    }

    public Integer getTakePrizeCycle() {
        return takePrizeCycle;
    }

    public void setTakePrizeCycle(Integer takePrizeCycle) {
        this.takePrizeCycle = takePrizeCycle;
    }

    public String getTakePrizeTimeStr() {
        return takePrizeTimeStr;
    }

    public void setTakePrizeTimeStr(String takePrizeTimeStr) {
        this.takePrizeTimeStr = takePrizeTimeStr;
    }

    public SignTreasureStockWarnTypeEnum getStockWarnType() {
        return stockWarnType;
    }

    public void setStockWarnType(SignTreasureStockWarnTypeEnum stockWarnType) {
        this.stockWarnType = stockWarnType;
    }

    public String getStockWarnDetail() {
        return stockWarnDetail;
    }

    public void setStockWarnDetail(String stockWarnDetail) {
        this.stockWarnDetail = stockWarnDetail;
    }

    public SignTreasureAwardStyleEnum getAwardStyle() {
        return awardStyle;
    }

    public void setAwardStyle(SignTreasureAwardStyleEnum awardStyle) {
        this.awardStyle = awardStyle;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getTakePrizeTime() {
        return takePrizeTime;
    }

    public void setTakePrizeTime(Date takePrizeTime) {
        this.takePrizeTime = takePrizeTime;
    }

    public String getPhaseNumber() {
        return phaseNumber;
    }

    public void setPhaseNumber(String phaseNumber) {
        this.phaseNumber = phaseNumber;
    }

    public SignTreasurePhaseStatusEnum getPhaseStatus() {
        return phaseStatus;
    }

    public void setPhaseStatus(SignTreasurePhaseStatusEnum phaseStatus) {
        this.phaseStatus = phaseStatus;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public List<SignTreasureOptionDto> getOptions() {
        return options;
    }

    public void setOptions(List<SignTreasureOptionDto> options) {
        this.options = options;
    }

    public SignTreasureActStatusEnum getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(SignTreasureActStatusEnum activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Date getActStartTime() {
        return actStartTime;
    }

    public void setActStartTime(Date actStartTime) {
        this.actStartTime = actStartTime;
    }
}
