package cn.com.duiba.sign.center.api.enums.signcomponent;

import com.google.common.collect.Maps;

import javax.annotation.CheckForNull;
import java.util.Map;

/**
 * 签到组件化 签到自定义周期模式
 * Created by 歪大哥😁 on 2019-08-22.
 */
public enum SignCycleModeEnum {

    MONTH(1, "自然月"),
    REGULAR(2, "固定周期"),
    ;

    private static final Map<Integer, SignCycleModeEnum> ALL_MAPPING;

    static {
        Map<Integer, SignCycleModeEnum> temp = Maps.newHashMap();
        for (SignCycleModeEnum value : values()) {
            temp.put(value.code, value);
        }
        ALL_MAPPING = temp;
    }

    private Integer code;
    private String desc;

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    SignCycleModeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    @CheckForNull
    public static SignCycleModeEnum getType(Integer code) {
        return ALL_MAPPING.get(code);
    }

}
