package cn.com.duiba.sign.center.api.enums.signcomponent;

/**
 * 签到状态
 * Created by 歪大哥😁 on 2019-08-28.
 */
public enum SignStatusEnum {

    // 初始化 生成记录可以认为签到已经成功
    CREATE(1, "初始化"),

    // 防止重复发奖 设置一个发奖中的中间态
    REWARD_PROCESSING(100, "奖励发放中"),

    FAIL(998, "签到失败"),
    // 奖励发放完毕 不代表奖励发放成功 是指奖励发放执行完毕
    // 所以最终所有数据都会以success状态完结
    SUCCESS(999, "签到成功-奖励发放完毕"),
     ;

    private Integer code;
    private String desc;

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    SignStatusEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

}
