package cn.com.duiba.sign.center.api.enums.signcontract;

/**
 * 契约签到排行榜类型
 */
public enum ContractRankTypeEnum {
    SIGN_COUNT_RANK(1, "打卡次数"),
    REWARD_RANK(2, "周期收益排行榜"),;
    private Integer code;
    private String desc;

    ContractRankTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ContractRankTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ContractRankTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
