package cn.com.duiba.sign.center.api.enums.signpet;

import java.util.HashMap;
import java.util.Map;

public enum ExchangeTypeEnum {
    /**
     * 道具兑换方式：1-积分 2-粮食
     **/
    PET_PROP_TYPE_CREDITS(1,"积分"),
    PET_PROP_TYPE_FOOD(2,"粮食")
    ;
    private int code;
    private String desc;
    ExchangeTypeEnum(int code,String desc){
        this.code=code;
        this.desc=desc;
    }
    private static Map<Integer,ExchangeTypeEnum>typeMap=new HashMap<>();
    static {
        for (ExchangeTypeEnum exchangeTypeEnum:values()){
            typeMap.put(exchangeTypeEnum.getCode(),exchangeTypeEnum);
        }
    }
    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static ExchangeTypeEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            return null;
        }
        return typeMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
