/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sign.center.api.enums.creditssign;

import cn.com.duiba.sign.center.api.dto.SignRewardRuleDto;
import cn.com.duiba.sign.center.api.dto.SignRewardRuleItemDto;
import cn.com.duiba.sign.center.api.exception.SignCenterException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public enum SignRewardTypeEnum {
    CONTINUE(1, "\u8fde\u7eed\u5956\u52b1"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            int circle = rewardRule.getItems().size();
            int index = continueDay > circle ? circle : continueDay;
            return rewardRule.getItems().get(index - 1);
        }
    }
    ,
    CIRCLE(2, "\u5468\u671f\u5956\u52b1"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            int circle = rewardRule.getItems().size();
            int index = continueDay % circle;
            index = index == 0 ? circle : index;
            return rewardRule.getItems().get(index - 1);
        }
    }
    ,
    ACCUMULATE(3, "\u7d2f\u8ba1\u5956\u52b1"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            for (SignRewardRuleItemDto item : rewardRule.getItems()) {
                if (item.getDays() == null || !Objects.equals(item.getDays(), continueDay)) continue;
                return item;
            }
            return new SignRewardRuleItemDto();
        }
    }
    ,
    SPEC_DAY(4, "\u7279\u6b8a\u65e5\u671f\u5956\u52b1"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            return new SignRewardRuleItemDto();
        }
    }
    ,
    FIRST_SIGN(5, "\u9996\u6b21\u7b7e\u5230\u5956\u52b1"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            return new SignRewardRuleItemDto();
        }
    }
    ,
    FULL_SIGN(6, "\u6ee1\u7b7e\u5956\u52b1"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            return new SignRewardRuleItemDto();
        }
    }
    ,
    CONTINUE_ONCE(7, "\u5468\u671f\u5185\u8fde\u7eed\u5956\u52b1(\u5355\u6b21)"){

        @Override
        protected SignRewardRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            for (SignRewardRuleItemDto item : rewardRule.getItems()) {
                if (item.getDays() == null || !Objects.equals(item.getDays(), continueDay)) continue;
                return item;
            }
            return new SignRewardRuleItemDto();
        }
    };

    private Integer code;
    private String desc;
    private static Map<Integer, SignRewardTypeEnum> typeMap;

    public static SignRewardTypeEnum getByCode(Integer type) {
        return typeMap.get(type);
    }

    private SignRewardTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public SignRewardRuleItemDto getRuleItem(Integer continueDay, SignRewardRuleDto rewardRule) {
        if (continueDay < 0 || rewardRule == null) {
            throw new SignCenterException("\u53c2\u6570\u975e\u6cd5");
        }
        if (!Boolean.TRUE.equals(rewardRule.getOpen()) || CollectionUtils.isEmpty(rewardRule.getItems())) {
            return new SignRewardRuleItemDto();
        }
        return this.getRuleItemSub(continueDay, rewardRule);
    }

    protected abstract SignRewardRuleItemDto getRuleItemSub(int var1, SignRewardRuleDto var2);

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        typeMap = new HashMap<Integer, SignRewardTypeEnum>();
        for (SignRewardTypeEnum rwType : SignRewardTypeEnum.values()) {
            typeMap.put(rwType.getCode(), rwType);
        }
    }
}

