package cn.com.duiba.sign.center.api.dto.signcomponent;


import java.io.Serializable;
import java.util.Date;

/**
 * 日历签到组件化-签到日志
 * Created by 歪大哥😁 on 2019-08-28.
 */
public class SignComponentLogDto implements Serializable {

    private static final long serialVersionUID = -144403699904445163L;

    /** 主键id */
    private Long id;
    /** 兑吧用户id */
    private Long consumerId;
    /** 应用id */
    private Long appId;
    /** 开发者用户id */
    private String partnerUserId;
    /** 签到活动入库id */
    private Long signOperatingId;
    /** 签到活动类型 9-签到组件化 */
    private Integer signType;
    /** 签到周期类型 1-连续签到 2-周期签到 3-定期-自然月 4-定期-自定义 */
    private Integer signCycleType;
    /** 当前周期开始时间 为空表示没有期限 */
    private Long startTime;
    /** 当前周期结束时间 为空表示没有期限 */
    private Long endTime;
    /** 签到月份 yyyyMM */
    private Integer signMonth;
    /** 签到日期 yyyyMMdd */
    private Integer signDate;
    /** 当前周期累计签到数 */
    private Integer totalCount;
    /** 当前周期连续签到数 */
    private Integer consecutiveCount;
    /** 本次签到是否为补签 1-补签 0-正常签到 */
    private Integer resign;
    /** 积分奖励明细 */
    private String creditsReward;
    /** 抽奖次数奖励明细 */
    private String drawCountReward;
    /** 签到记录状态  1-初始化  100-发奖中 998-发奖失败 999-发奖成功 */
    private Integer signStatus;
    /** 签到失败原因 */
    private String errorMsg;
    /** 创建时间 */
    private Date gmtCredits;
    /** 修改时间 */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Long getSignOperatingId() {
        return signOperatingId;
    }

    public void setSignOperatingId(Long signOperatingId) {
        this.signOperatingId = signOperatingId;
    }

    public Integer getSignType() {
        return signType;
    }

    public void setSignType(Integer signType) {
        this.signType = signType;
    }

    public Integer getSignCycleType() {
        return signCycleType;
    }

    public void setSignCycleType(Integer signCycleType) {
        this.signCycleType = signCycleType;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Integer getSignMonth() {
        return signMonth;
    }

    public void setSignMonth(Integer signMonth) {
        this.signMonth = signMonth;
    }

    public Integer getSignDate() {
        return signDate;
    }

    public void setSignDate(Integer signDate) {
        this.signDate = signDate;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getConsecutiveCount() {
        return consecutiveCount;
    }

    public void setConsecutiveCount(Integer consecutiveCount) {
        this.consecutiveCount = consecutiveCount;
    }

    public Integer getResign() {
        return resign;
    }

    public void setResign(Integer resign) {
        this.resign = resign;
    }

    public String getCreditsReward() {
        return creditsReward;
    }

    public void setCreditsReward(String creditsReward) {
        this.creditsReward = creditsReward;
    }

    public String getDrawCountReward() {
        return drawCountReward;
    }

    public void setDrawCountReward(String drawCountReward) {
        this.drawCountReward = drawCountReward;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Date getGmtCredits() {
        return gmtCredits;
    }

    public void setGmtCredits(Date gmtCredits) {
        this.gmtCredits = gmtCredits;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
