package cn.com.duiba.sign.center.api.params;

import java.io.Serializable;

/**
 * <p>奖励详情</p>
 * <p>created by Xuwei on 2021/3/23<p>
 **/
public class SignComponentRewardDetailParam implements Serializable {

    private static final long serialVersionUID = 1743507223406360262L;

    /**
     * 正常签到
     */
    public static final Integer SIGN = 1;
    /**
     * 补签
     */
    public static final Integer RESIGN = 2;
    /**
     * 手动领取
     */
    public static final Integer MANUAL = 3;

    /**
     * 奖励类型
     * @see cn.com.duiba.sign.center.api.enums.signcomponent.SignRewardTypeEnum
     */
    private Integer type;
    /**
     * 奖励数量
     */
    private Integer num;
    /**
     * 奖励来源
     */
    private Integer from;

    public SignComponentRewardDetailParam(Integer type, Integer num, Integer from) {
        this.type = type;
        this.num = num;
        this.from = from;
    }

    public SignComponentRewardDetailParam() {
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public Integer getFrom() {
        return from;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }
}
