package cn.com.duiba.sign.center.api.enums.signpet;

import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liugq
 * @date created in 2018/4/26
 * @description:
 */
public enum SignPetRewardEnum {

    PET_REWARD_TYPE_NONE(1,"无奖励"),
    PET_REWARD_TYPE_FOOD(2,"粮食"),
    PET_REWARD_TYPE_LOTTERY(3,"抽奖活动"),
    PET_REWARD_TYPE_CARD(4,"集卡活动")
    ;
    private String desc;
    private int code;

    SignPetRewardEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,SignPetRewardEnum> typeMap = new HashMap<>();
    static{
        for(SignPetRewardEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static SignPetRewardEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            throw new SignCenterException("不支持的喂养状态，status="+code);
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
