package cn.com.duiba.sign.center.api.dto.signtreasure;

import cn.com.duiba.sign.center.api.enums.signtreasure.SignTreasureAwardStyleEnum;
import cn.com.duiba.sign.center.api.enums.signtreasure.SignTreasurePhaseStatusEnum;
import cn.com.duiba.sign.center.api.enums.signtreasure.SignTreasureStockWarnTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
* 夺宝签到期次表
*/
public class SignTreasurePhaseDto implements Serializable {

    private static final long serialVersionUID = -2710756333636836576L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 对应夺宝签到活动id
     */
    private Long actId;

    /**
     * 奖励方式 0-每日签到一个 1-获得连签天数数量
     */
    private SignTreasureAwardStyleEnum awardStyle;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 开奖时间
     */
    private Date takePrizeTime;

    /**
     * 期次号（期次开始时间的年月日格式）
     */
    private String phaseNumber;

    /**
     * 期次状态 期次状态 0-进行中，1-待开奖 2-已开奖
     */
    private SignTreasurePhaseStatusEnum phaseStatus;

    /**
     * 当前期次序号
     */
    private Integer payload;

    /**
     * 当前期次获奖扑克牌
     */
    private String winCode;

    /**
     * （活动快照）标题
     */
    private String title;

    /**
     * （活动快照）规则
     */
    private String rule;

    /**
     * （活动快照）入口缩略图
     */
    private String smallImage;

    /**
     * （活动快照）banner图
     */
    private String bannerImage;

    /**
     * （活动快照）界面配置
     */
    private String skinConfig;

    /**
     * （活动快照）展示中奖轮播 0-不支持 1-支持
     */
    private Boolean showWinRecord;

    /**
     * （活动快照）是否支持积分兑换 0-不支持 1-支持
     */
    private Boolean creditsSupport;

    /**
     * （活动快照）单次兑换消耗积分数量
     */
    private Integer credits;

    /**
     * （活动快照）购买上限
     */
    private Integer maxPurchaseAmount;

    /**
     * （活动快照）是否自动续期 0-不续期，1-续期
     */
    private Boolean autoContinue;

    /**
     * （活动快照）自动续期数
     */
    private Integer autoContinueCount;

    /**
     * （活动快照）活动周期
     */
    private Integer activityCycle;

    /**
     * （活动快照）结束后多久开奖（天数）
     */
    private Integer takePrizeCycle;

    /**
     * （活动快照）开奖时间 hh:mm格式
     */
    private String takePrizeTimeStr;

    /**
     * （活动快照）库存预警类型 0-邮箱 1-手机
     */
    private SignTreasureStockWarnTypeEnum stockWarnType;

    /**
     * （活动快照）库存预警发送方具体信息
     */
    private String stockWarnDetail;



    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setActId(Long actId) {
        this.actId = actId;
    }

    public Long getActId() {
        return actId;
    }

    public SignTreasureAwardStyleEnum getAwardStyle() {
        return awardStyle;
    }

    public void setAwardStyle(SignTreasureAwardStyleEnum awardStyle) {
        this.awardStyle = awardStyle;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setTakePrizeTime(Date takePrizeTime) {
        this.takePrizeTime = takePrizeTime;
    }

    public Date getTakePrizeTime() {
        return takePrizeTime;
    }

    public SignTreasurePhaseStatusEnum getPhaseStatus() {
        return phaseStatus;
    }

    public void setPhaseStatus(SignTreasurePhaseStatusEnum phaseStatus) {
        this.phaseStatus = phaseStatus;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setWinCode(String winCode) {
        this.winCode = winCode;
    }

    public String getWinCode() {
        return winCode;
    }

    public String getPhaseNumber() {
        return phaseNumber;
    }

    public void setPhaseNumber(String phaseNumber) {
        this.phaseNumber = phaseNumber;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getSkinConfig() {
        return skinConfig;
    }

    public void setSkinConfig(String skinConfig) {
        this.skinConfig = skinConfig;
    }

    public Boolean getShowWinRecord() {
        return showWinRecord;
    }

    public void setShowWinRecord(Boolean showWinRecord) {
        this.showWinRecord = showWinRecord;
    }

    public Boolean getCreditsSupport() {
        return creditsSupport;
    }

    public void setCreditsSupport(Boolean creditsSupport) {
        this.creditsSupport = creditsSupport;
    }

    public void setAutoContinue(Boolean autoContinue) {
        this.autoContinue = autoContinue;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getMaxPurchaseAmount() {
        return maxPurchaseAmount;
    }

    public void setMaxPurchaseAmount(Integer maxPurchaseAmount) {
        this.maxPurchaseAmount = maxPurchaseAmount;
    }

    public Integer getAutoContinueCount() {
        return autoContinueCount;
    }

    public void setAutoContinueCount(Integer autoContinueCount) {
        this.autoContinueCount = autoContinueCount;
    }

    public Integer getActivityCycle() {
        return activityCycle;
    }

    public void setActivityCycle(Integer activityCycle) {
        this.activityCycle = activityCycle;
    }

    public Integer getTakePrizeCycle() {
        return takePrizeCycle;
    }

    public void setTakePrizeCycle(Integer takePrizeCycle) {
        this.takePrizeCycle = takePrizeCycle;
    }

    public String getTakePrizeTimeStr() {
        return takePrizeTimeStr;
    }

    public void setTakePrizeTimeStr(String takePrizeTimeStr) {
        this.takePrizeTimeStr = takePrizeTimeStr;
    }

    public SignTreasureStockWarnTypeEnum getStockWarnType() {
        return stockWarnType;
    }

    public void setStockWarnType(SignTreasureStockWarnTypeEnum stockWarnType) {
        this.stockWarnType = stockWarnType;
    }

    public String getStockWarnDetail() {
        return stockWarnDetail;
    }

    public void setStockWarnDetail(String stockWarnDetail) {
        this.stockWarnDetail = stockWarnDetail;
    }

    public Boolean getAutoContinue() {
        return autoContinue;
    }
}

