package cn.com.duiba.sign.center.api.enums.signpet;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Liugq on 2018/7/12.
 * 宠物粮食来源
 */
public enum PetFoodFromTypeEnum {
    PET_FOOD_FROM_TYPE_AUTO(1,"自动"),
    PET_FOOD_FROM_TYPE_EXCHANGE_(2,"兑换"),
    PET_FOOD_FROM_TYPE_LOGIN(3,"登录"),
    PET_FOOD_FROM_TYPE_DEVELOPER(4,"开发者"),
    PET_FOOD_FROM_TYPE_INITIALIZATION(5, "初始化")
    ;
    private String desc;
    private int code;
    PetFoodFromTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,PetFoodFromTypeEnum> typeMap = new HashMap<>();
    static{
        for(PetFoodFromTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static PetFoodFromTypeEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            return null;
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
