package cn.com.duiba.sign.center.api.enums.signpet;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liugq
 * created in 2018/5/15
 * 宠物装饰道具类型
 */
public enum ToyTypeEnum {
    TOY_TYPE_STATUS(1,"状态类"),
    TOY_TYPE_DECORATION(2,"装饰类"),
    TOY_TYPE_FUNTION(3,"功能类"),
    TOY_TYPE_FOOD(4,"食物类"),
    TOY_TYPE_TOY(5,"玩具类")
    ;
    private String desc;
    private int code;

    ToyTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,ToyTypeEnum> typeMap = new HashMap<>();
    static{
        for(ToyTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     */
    public static ToyTypeEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            return null;
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
