package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignInviteRecordDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.params.SignInviteUkParam;
import java.util.List;

/**
 * Created by Liugq on 2018/9/13.
 */
@AdvancedFeignClient
public interface RemoteSignInviteService {

    /**
     * 插入
     *
     * @param dto
     * @return
     */
    Long findOrInsert(SignInviteRecordDto dto);

    /**
     * 修改任务进度状态
     *
     * @param id
     * @param switchs
     * @return
     */
    Integer updateSwitchs(Long id, Integer switchs);

    /**
     * 根据唯一索引查询
     *
     * @param param
     * @return
     */
    SignInviteRecordDto findByUk(SignInviteUkParam param);

    /**
     * 根据分享码查询邀请列表
     *
     * @param shareCode
     * @param actId
     * @param actType
     * @return
     */
    List<SignInviteRecordDto> selectByShareCode(String shareCode, Long actId, SignActivityTypeEnum actType);
}
