package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignOperatingPositionDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.params.SignOperatingPositionQueryParam;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/12/5.
 */
@AdvancedFeignClient
public interface RemoteSignOperatingPositionService {
    /**
     * 插入操作
     * @param dto 数据表对应的实体类
     * @return
     */
    long insert(SignOperatingPositionDto dto);
    /**
     * 根据主键删除对应数据
     * @param id
     * @return
     */
    int deleteById(Long id);
    /**
     * 根据主键更新对应数据条目
     * @param dto
     * @return
     */
    int updateById(SignOperatingPositionDto dto);
    /**
     * 根据主键更新对应数据条目，如果entity数据域为null则不更新对应数据域
     * @param dto
     * @return
     */
    int updateByIdSelective(SignOperatingPositionDto dto);
    /**
     * 根据主键查询对应数据条目
     * @param id
     * @return
     */
    SignOperatingPositionDto findById(Long id);

    /**
     * 批量查询
     * @param ids
     * @return
     */
    List<SignOperatingPositionDto> findByIds(List<Long> ids);

    /**
     * 根据查询条件返回相应数据条目，entity中值为null的数据域不作为查询条件
     * @param param
     * @return
     */
    List<SignOperatingPositionDto> findList(SignOperatingPositionQueryParam param);

    /**
     * 根据查询条件返回相应数据条目，entity中值为null的数据域不作为查询条件
     * @param pageParam
     * @return
     */
    List<SignOperatingPositionDto> pageSearch(SignOperatingPositionQueryParam pageParam);

    /**
     * 根据查询条件统计相应的数据条目数量
     * @param pageParam
     * @return
     */
    Integer count4PageSearch(SignOperatingPositionQueryParam pageParam);

    @Deprecated
    List<SignOperatingPositionDto> findBySignActId(Long signActivityId);

    /**
     * 查询活动的可用运营位
     * @param activityType
     * @param signActivityId
     * @return
     */
    List<SignOperatingPositionDto> findBySignActivityId(SignActivityTypeEnum activityType, Long signActivityId);
}
