package cn.com.duiba.sign.center.api.remoteservice.signrecord;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignInfoBasicDataDto;
import cn.com.duiba.sign.center.api.dto.SignInfoDto;
import cn.com.duiba.sign.center.api.dto.SignStaticsDto;
import cn.com.duiba.sign.center.api.params.PageParams;
import cn.com.duiba.sign.center.api.params.SignCreditsQueryParam;
import cn.com.duiba.sign.center.api.params.SignInfoQueryParam;
import cn.com.duiba.sign.center.api.params.SignStaticsQueryParam;

/**
 * 签到统计信息
 * Created by xiaoxuda on 2017/5/31.
 */
@AdvancedFeignClient
public interface RemoteSignStaticsService {
    /**
     * 根据用户ID、签到数据来源、来源关联ID查询签到统计信息
     * @param param
     * @return
     */
    SignStaticsDto findSignStaticsByUK(SignStaticsQueryParam param);


    /**
     * 获取用户当前签到信息
     * @param param
     * @return
     */
    SignInfoDto getSignInfoByConsumer(SignInfoQueryParam param);

    /**
     * 签到累计积分
     * @return 签到累计积分
     */
    Integer getSignTotalCredits(SignCreditsQueryParam param) throws BizException;

    /**
     * 分页查询
     * @param param
     * @param query
     * @return
     */
    Page<Long> pageApi(SignStaticsQueryParam param, PageParams query) throws BizException;

    /**
     * 获取用户当前签到的基础信息： 当天是否签到、连续天数
     * @param param
     * @return
     */
    SignInfoBasicDataDto queryUserBasicSignInfo(SignInfoQueryParam param);


}
