package cn.com.duiba.sign.center.api.enums.signpet;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Liugq on 2018/8/7.
 */
public enum ToySubTypeEnum {

    PET_TOY_TYPE_DEFAULT(0,"默认值"),
    PET_TOY_TYPE_EYE(1,"眼睛"),
    PET_TOY_TYPE_HEAD(2,"头部"),
    PET_TOY_TYPE_UPPER(3,"上身"),
    PET_TOY_TYPE_BOTTOM(4,"下身"),
    PET_TOY_TYPE_FOOT(5,"脚")
    ;
    private String desc;
    private int code;

    ToySubTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,ToySubTypeEnum> typeMap = new HashMap<>();
    static{
        for(ToySubTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static ToySubTypeEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            return null;
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
