package cn.com.duiba.sign.center.api.remoteservice.creditssign;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by fangdong on 2019/06/06
 */
@AdvancedFeignClient
public interface RemoteMonthVirtualCardService {

    /**
     * 增加/减少补签卡
     * @param consumerId 用户id
     * @param count 补签卡数量
     * @return 补签卡增加/减少后的数量
     */
    Long increase(Long consumerId, Long activityId, Long count) throws BizException;

    /**
     * 查询补签卡数量
     * @param consumerId 用户id
     * @return 补签卡数量
     */
    Long get(Long consumerId, Long activityId) throws BizException;

}
