package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignPetActivityToyDto;
import cn.com.duiba.sign.center.api.dto.SignPetPurchasedToyDto;
import cn.com.duiba.sign.center.api.dto.SignPetToyExchangeDto;
import cn.com.duiba.sign.center.api.dto.SignPetToyExchangeResultDto;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.enums.signpet.ToyTypeEnum;
import cn.com.duiba.sign.center.api.params.SignPetToyOrderParam;
import java.util.List;

/**
 * @author liugq
 * @date created in 2018/5/15
 * @description: 宠物道具
 */
@AdvancedFeignClient
public interface RemoteSignPetToyService {

    /**
     * 道具兑换
     * @param actToyId
     * @param ip
     * @param transfer
     */
    void createExchangeOrderNew(Long appId, Long consumerId, Long actToyId,String ip, String transfer) throws BizException;

    /**
     * 道具兑换
     * @param param
     * @return
     * @throws BizException
     */
    SignPetToyExchangeDto saveExchangeOrder(SignPetToyOrderParam param) throws BizException;

    /**
     * 获取道具兑换订单状态
     * @param orderId 订单id
     * @return 兑换状态
     * @throws BizException
     */
    SignPetToyExchangeResultDto getExchangeOrderStatus(Long orderId) throws BizException;


    /**
     * 查询道具商店展示的道具
     * @param actId
     * @return
     */
    List<SignPetActivityToyDto> selectActToy(Long actId, SignActivityTypeEnum actType);

    /**
     * 查询道具商店展示的道具
     *
     * @param actId 活动ID
     * @param identifier 标识符
     * @return
     */
    SignPetActivityToyDto selectByActIden(Long actId, String identifier);

    /**
     * 查询宠物拥有的道具
     * @param petId
     * @return
     */
    List<SignPetPurchasedToyDto> selectUserToy(Long petId, Long consumerId, ToyTypeEnum toyType);

    /**
     * 查询宠物正在使用的道具
     * @param petId
     * @return
     */
    List<SignPetPurchasedToyDto> selectUsingToy(Long petId,Long consumerId);
}
