/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.single.sign.on.client.web;

import cn.com.duiba.cloud.single.sign.on.client.cache.LoginStateCache;
import cn.com.duiba.cloud.single.sign.on.client.domain.dto.LoginStateDto;
import cn.com.duiba.cloud.single.sign.on.client.domain.request.OutLoginParam;
import cn.com.duiba.cloud.single.sign.on.client.remoteservice.RemoteSsoService;
import cn.com.duiba.cloud.single.sign.on.client.tool.SsoContext;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.constants.SsoProperties;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.annotation.CanAccess;
import cn.com.duiba.cloud.single.sign.on.contract.tool.CookieUtil;
import cn.com.duiba.cloud.single.sign.on.contract.tool.JsonRender;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginSuccessEvent;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sso"})
public class SsoController {
    private static final Logger log = LoggerFactory.getLogger(SsoController.class);
    @Resource
    private RemoteSsoService remoteSsoService;
    @Resource
    private SsoProperties properties;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private LoginStateCache loginStateCache;
    @Resource
    private Environment environment;

    @CanAccess
    @RequestMapping(value={"/ssoIndex"})
    public String ssoIndex(@RequestParam Long ssoStamp, @RequestParam(required=false) String redirect) throws SsoException {
        String ticket = this.remoteSsoService.findTicketByStamp(ssoStamp);
        if (StringUtils.isBlank((String)ticket)) {
            throw new SsoException("\u83b7\u53d6SSO\u901a\u884c\u8bc1\u5931\u8d25");
        }
        LoginStateDto loginState = this.remoteSsoService.verifyTicket(ticket);
        if (loginState == null) {
            throw new SsoException("ticket\u5931\u6548");
        }
        SsoContext.setLoginState(loginState);
        CookieUtil.setLoginCookie((String)ticket);
        LoginSuccessEvent event = new LoginSuccessEvent();
        event.setSession((Object)loginState);
        event.setRequest(SsoRequestTool.getRequest());
        event.setResponse(SsoRequestTool.getResponse());
        event.setExpirationTime(Integer.valueOf(46656000));
        this.applicationContext.publishEvent((Object)event);
        return "redirect:" + Optional.ofNullable(redirect).orElse(this.properties.getDefaultRedirectUrl());
    }

    @RequestMapping(value={"/outLogin"})
    @ResponseBody
    public JsonRender<Void> outLogin(@RequestParam(defaultValue="/") String redirect) {
        log.info("\u9000\u51fa\u767b\u5f55redirect:{}", (Object)redirect);
        String ticket = SsoContext.findTicket();
        this.loginStateCache.invalidateAll(Lists.newArrayList((Object[])new String[]{ticket}));
        this.remoteSsoService.outLogin(ticket);
        return JsonRender.success();
    }

    @CanAccess
    @ResponseBody
    @RequestMapping(value={"/logout"})
    public JsonRender<Map<String, String>> logout(@RequestBody @Valid OutLoginParam param) {
        this.loginStateCache.invalidateAll(param.getTickets());
        HashMap appInfo = Maps.newHashMap();
        appInfo.put("name", this.environment.getProperty("spring.application.name", ""));
        appInfo.put("port", this.environment.getProperty("server.port", ""));
        try {
            appInfo.put("ip", InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            log.error("\u83b7\u53d6\u672c\u5730ip\u5931\u8d25", (Throwable)e);
        }
        return JsonRender.success((Object)appInfo);
    }
}

