package cn.com.duiba.spider.domain.dto;

import java.io.Serializable;

public class HotKeyWordsDto implements Serializable{

    private static final long serialVersionUID = -8577218806117455910L;
    /**
     * 热搜词
     */
    private String keyWords;

    /**
     * 热度
     */
    private int score;

    /**
     * 标签 利用二进制表示 1表示有，0表示没有
     * 第一位表示是否是"热"标签
     * 第二位表示是否是"新"标签
     * 二进制最终转换为十进制计算的最终结果如下
     * @see cn.com.duiba.spider.domain.constant.TagEnum
     */
    private int tag;

    public String getKeyWords() {
        return keyWords;
    }

    public void setKeyWords(String keyWords) {
        this.keyWords = keyWords;
    }

    public int getScore() {
        return score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getTag() {
        return tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof HotKeyWordsDto)) return false;

        HotKeyWordsDto dto = (HotKeyWordsDto) o;

        return getKeyWords() != null ? getKeyWords().equals(dto.getKeyWords()) : dto.getKeyWords() == null;
    }

    @Override
    public int hashCode() {
        return getKeyWords() != null ? getKeyWords().hashCode() : 0;
    }

    @Override
    public String toString() {
        return "HotKeyWordsDto{" +
                "keyWords='" + keyWords + '\'' +
                ", score=" + score +
                ", tag=" + tag +
                '}';
    }
}
