package cn.com.duiba.spider.domain.dto;

import java.io.Serializable;
import java.util.List;

/**
 * 热点新闻列表
 */
public class HotKeywordListDto implements Serializable{

    private static final long serialVersionUID = -6749627012150100701L;

    /**
     * 是否有更新
     */
    private boolean isUpdate;

    /**
     * 文本内容
     */
    private List<HotKeyWordsDto> hotKeyWordsDtos;

    public List<HotKeyWordsDto> getHotKeyWordsDtos() {
        return hotKeyWordsDtos;
    }

    public void setHotKeyWordsDtos(List<HotKeyWordsDto> hotKeyWordsDtos) {
        this.hotKeyWordsDtos = hotKeyWordsDtos;
    }

    public boolean isUpdate() {
        return isUpdate;
    }

    public void setUpdate(boolean update) {
        isUpdate = update;
    }

    public static HotKeywordListDto parse(List<HotKeyWordsDto> hots, boolean update){
        HotKeywordListDto dto = new HotKeywordListDto();
        dto.setUpdate(update);
        dto.setHotKeyWordsDtos(hots);
        return dto;
    }
}
