package cn.com.duiba.spider.util.maiquan;

import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.zxing.*;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author: sjx
 * @date: 2019-06-11 14:28
 */
public class ImageUtil {

    /**
     * 根据地址获取图片对象（宽高等）
     *
     * @param url
     * @return
     */
    public static DefaultDto.Image getByUrl(String url) {
        if (StringUtils.isBlank(url)) {
            return null;
        }
        try {
            BufferedImage read = ImageIO.read(new URL(url));
            //过滤二维码
            if (isQrCode(read)) {
                return null;
            }
            if (read.getHeight() >= 200 && read.getWidth() >= 200) {
                return new DefaultDto.Image(read.getHeight(), read.getWidth(), url);
            }
        } catch (Exception e) {
            //do nothing
        }
        return null;
    }

    /**
     * 识别图片含有二维码
     *
     * @param read
     * @return
     */
    public static boolean isQrCode(BufferedImage read) {
        try {
            readQrCode(read);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 识别图片中二维码
     *
     * @param read
     * @return
     * @throws NotFoundException
     */
    public static Result readQrCode(BufferedImage read) throws NotFoundException {
        BinaryBitmap binaryBitmap = new BinaryBitmap(new HybridBinarizer(new BufferedImageLuminanceSource(read)));
        Map hints = Maps.newHashMap();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        MultiFormatReader formatReader = new MultiFormatReader();
        return formatReader.decode(binaryBitmap, hints);
    }

    /**
     * 根据地址列表获取图片对象列表
     *
     * @param urls
     * @return
     */
    public static List<DefaultDto.Image> listByUrls(Collection<String> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return Lists.newArrayList();
        }
        List<DefaultDto.Image> images = Lists.newArrayList();
        urls.forEach(url -> {
            DefaultDto.Image byUrl = getByUrl(url);
            if (byUrl != null) {
                images.add(byUrl);
            }
        });
        return images;
    }

    public static void main(String[] args) throws IOException {
        //do nothing
        //String url = "https://mmbiz.qpic.cn/mmbiz_png/yGaInYia6xh0KiaQwdv8afm5QgRSGAB1lJ6NZ1CxRdvFqgrX36lWmoiasfmBykEiaExKbhYyrXbPRNKqxMcic9Mzm5A/640?wx_fmt=png";
        //System.err.println(JSON.toJSONString(getByUrl(url)));
    }
}
