package cn.com.duiba.spider.util.maiquan.constant;

import cn.com.duiba.spider.util.maiquan.spider.*;

/**
 * @author: sjx
 * @date: 2019-05-27 14:53
 */
public enum ContentSource {
    GONGZHONGHAO(1, "微信公众号", GongZhongHaoSpider.SPIDER),
    KUAISHOU(2, "快手", UnknownSpider.SPIDER),
    DOUYIN(3, "抖音", UnknownSpider.SPIDER),
    PIPIXIA(4, "皮皮虾", PiPiXiaSpider.SPIDER),
    MEIPIAN(5, "美篇", MeiPianSpider.SPIDER),
    TANGDOU(6, "糖豆", UnknownSpider.SPIDER),
    TIAOBA(7, "跳吧广场舞", TiaoBaSpider.SPIDER),
    LISHIPIN(8, "梨视频", LiSpider.SPIDER),
    XIGUA(9, "西瓜视频", XiGuaVideoSpider.SPIDER),
    TOUTIAOSHEYING(10, "头条摄影集", TouTiaoPicSpider.SPIDER),
    XINLANGTUPIAN(11, "新浪图片", XinLangSpider.SPIDER),
    SOUGOUWEIXIN(12, "搜狗微信", SougouWeiXinSpider.SPIDER),
    TX_XINWEN_SHEHUI(13, "腾讯新闻-社会", UnknownSpider.SPIDER),
    TX_XINWEN_24(14, "腾讯新闻-24小时热点", UnknownSpider.SPIDER),
    PEOPLE_NEWS(15, "人民网新闻", UnknownSpider.SPIDER),
    UNKNOWN(999, "未知源", UnknownSpider.SPIDER),
    ;

    private int code;

    private String desc;

    private AbstractSpider spider;

    ContentSource(int code, String desc, AbstractSpider spider) {
        this.code = code;
        this.desc = desc;
        this.spider = spider;
    }

    public AbstractSpider getSpider() {
        return spider;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
