package cn.com.duiba.spider.util.maiquan.dto;

import cn.com.duiba.spider.util.maiquan.constant.ContentForm;
import cn.com.duiba.spider.util.maiquan.constant.ContentSlotType;
import cn.com.duiba.spider.util.maiquan.tts.baidu.keyword.BaiduKeywordUtil;

import java.util.List;
import java.util.Map;

/**
 * @author: sjx
 * @date: 2019-05-27 15:03
 */
public class DefaultDto {
    /**
     * 原链接
     */
    private String sourceUrl;

    /**
     * 有些连接需要配置，否则打不开。
     * 使用web打开url时将本字段内容全部添加进header
     */
    private Map<String, String> headers;

    /**
     * 有些连接需要配置，否则打不开。
     * 使用web打开url时将本字段内容全部添加进请求cookie
     */
    private List<String> cookies;

    /**
     * 源类型 1:公众号 2:快手 3:抖音 4:皮皮虾 5:美篇 6:糖豆 999:未知
     */
    private Integer sourceType;

    /**
     * 文章分类 根据来源制定分类，0统一表示为默认
     */
    private String contentType;

    /**
     * 源Id
     */
    private String sourceId;

    /**
     * 标题
     */
    private String postTitle;

    /**
     * 副标题
     */
    private String subtitle;

    /**
     * 视频地址（如果有）
     */
    private String videoUrl;

    /**
     * 原文摘要
     */
    private String sourceAbstract;

    /**
     * 全文本
     */
    private String fullText;

    /**
     * 图片地址
     */
    private List<String> imageList;

    /**
     * 图片对象集合
     */
    private List<Image> images;

    /**
     * 作者信息
     */
    private Author author;

    /**
     * 评论信息
     */
    private List<Comment> comments;

    /**
     * 音频列表
     */
    private List<Speech> speeches;

    /**
     * 文章标签
     */
    private BaiduKeywordUtil.Tags tags;

    /**
     * 内容形式
     *
     * @see cn.com.duiba.spider.util.maiquan.constant.ContentForm
     */
    private Integer contentForm;

    /**
     * 内容位置类型
     *
     * @see cn.com.duiba.spider.util.maiquan.constant.ContentSlotType
     * 默认值：0（ContentSlotType.FEED.type,信息流展示）
     */
    private Integer contentSlotType;

    public DefaultDto() {
    }

    public DefaultDto(String sourceUrl, Integer sourceType) {
        this(sourceUrl, sourceType, ContentForm.ARTICLE.getForm());
    }

    public DefaultDto(String sourceUrl, Integer sourceType, Integer contentForm) {
        this(sourceUrl, sourceType, contentForm, ContentSlotType.FEED.getType());
    }

    public DefaultDto(String sourceUrl, Integer sourceType, Integer contentForm, Integer contentSlotType) {
        this.sourceUrl = sourceUrl;
        this.sourceType = sourceType;
        this.contentForm = contentForm;
        this.contentSlotType = contentSlotType;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getPostTitle() {
        return postTitle;
    }

    public void setPostTitle(String postTitle) {
        this.postTitle = postTitle;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public String getSourceAbstract() {
        return sourceAbstract;
    }

    public void setSourceAbstract(String sourceAbstract) {
        this.sourceAbstract = sourceAbstract;
    }

    public List<String> getImageList() {
        return imageList;
    }

    public void setImageList(List<String> imageList) {
        this.imageList = imageList;
    }

    public Author getAuthor() {
        return author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public List<Image> getImages() {
        return images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public List<Comment> getComments() {
        return comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public List<Speech> getSpeeches() {
        return speeches;
    }

    public void setSpeeches(List<Speech> speeches) {
        this.speeches = speeches;
    }

    public String getFullText() {
        return fullText;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    public BaiduKeywordUtil.Tags getTags() {
        return tags;
    }

    public void setTags(BaiduKeywordUtil.Tags tags) {
        this.tags = tags;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public List<String> getCookies() {
        return cookies;
    }

    public void setCookies(List<String> cookies) {
        this.cookies = cookies;
    }

    public Integer getContentForm() {
        return contentForm;
    }

    public void setContentForm(Integer contentForm) {
        this.contentForm = contentForm;
    }

    public Integer getContentSlotType() {
        return contentSlotType;
    }

    public void setContentSlotType(Integer contentSlotType) {
        this.contentSlotType = contentSlotType;
    }

    /**
     * 作者信息
     */
    public static class Author {
        //昵称
        private String nickname;
        //头像
        private String headImg;

        //描述
        private String desc;

        public Author(String nickname, String headImg) {
            this.nickname = nickname;
            this.headImg = headImg;
        }

        public Author(String nickname, String headImg, String desc) {
            this.nickname = nickname;
            this.headImg = headImg;
            this.desc = desc;
        }

        public String getNickname() {
            return nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public String getHeadImg() {
            return headImg;
        }

        public void setHeadImg(String headImg) {
            this.headImg = headImg;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 图片对象
     */
    public static class Image {

        //高
        private int height;

        //宽
        private int width;

        //地址
        private String url;

        public Image() {
        }

        public Image(int height, int width, String url) {
            this.height = height;
            this.width = width;
            this.url = url;
        }

        public int getHeight() {
            return height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getWidth() {
            return width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }


    public static class Comment {
        //评论内容
        private String text;
        //评论者头像
        private String headImg;
        //评论者名称
        private String name;

        public Comment() {
        }

        public Comment(String text, String headImg, String name) {
            this.text = text;
            this.headImg = headImg;
            this.name = name;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getHeadImg() {
            return headImg;
        }

        public void setHeadImg(String headImg) {
            this.headImg = headImg;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    /**
     * 语音对象
     */
    public static class Speech {
        //音频地址
        private String url;

        //length of time 音频时长
        private long lot;

        public Speech() {
        }

        public Speech(String url) {
            this.url = url;
        }

        public Speech(String url, long lot) {
            this.url = url;
            this.lot = lot;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public long getLot() {
            return lot;
        }

        public void setLot(long lot) {
            this.lot = lot;
        }
    }
}
