package cn.com.duiba.spider.util.maiquan.dto;

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.List;

/**
 * @author: sjx
 * @date: 2019-09-06 10:25
 */
public class RecommendMsgListDto implements Serializable {

    private List<RecommendMsg> msgs;

    public RecommendMsgListDto() {
    }

    public RecommendMsgListDto(List<RecommendMsg> msgs) {
        this.msgs = msgs;
    }

    public RecommendMsgListDto(String url, Integer sourceType, String contentType) {
        this(Lists.newArrayList(new RecommendMsg(url, sourceType, contentType)));
    }


    public List<RecommendMsg> getMsgs() {
        return msgs;
    }

    public void setMsgs(List<RecommendMsg> msgs) {
        this.msgs = msgs;
    }

    /**
     * 消息对象
     */
    public static class RecommendMsg implements Serializable {

        /**
         * 文章url
         */
        private String url;

        /**
         * 源类型 1:公众号 2:快手 3:抖音 4:皮皮虾 5:美篇 6:糖豆 999:未知
         */
        private Integer sourceType;

        /**
         * 文章分类 根据来源制定分类，0统一表示为默认
         */
        private String contentType;

        public RecommendMsg(String url, Integer sourceType, String contentType) {
            this.url = url;
            this.sourceType = sourceType;
            this.contentType = contentType;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Integer getSourceType() {
            return sourceType;
        }

        public void setSourceType(Integer sourceType) {
            this.sourceType = sourceType;
        }

        public String getContentType() {
            return contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }
}
