package cn.com.duiba.spider.util.maiquan.exception;

/**
 * 麦全业务爬虫异常
 *
 * @author: sjx
 * @date: 2019-05-27 14:12
 */
public class MaiQuanSpiderException extends RuntimeException {

    private String errorCode;

    private String message;

    public MaiQuanSpiderException(ErrorCode errorCode) {
        this.errorCode = errorCode.getCode();
        this.message = errorCode.getDesc();
    }

    public MaiQuanSpiderException(String errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public MaiQuanSpiderException(ErrorCode errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode.getCode();
        this.message = errorCode.getDesc();
    }

    public MaiQuanSpiderException(String errorCode, String message, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
        this.message = message;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
