package cn.com.duiba.spider.util.maiquan.proxy;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import java.util.concurrent.TimeUnit;

/**
 * @author: Administrator
 * @date: 2019-07-10 18:23
 */
public class Data5UProxyProvider {

    private static final String API = "http://api.ip.data5u.com/dynamic/get.html?order=527ee86b323a33093c1962fa65e44d2d&sep=5";

    private static Cache<String, Proxy> PROXYCACHE = CacheBuilder.newBuilder()
            .expireAfterWrite(5, TimeUnit.SECONDS)  //5秒过期，Data5u提供的代理有1分钟过期，2分钟过期，5分钟过期
            .maximumSize(10).build();

    public static Proxy getProxy() throws Exception {
        return PROXYCACHE.get("data5U", () -> getProxyFromData5u());
    }

    public static void clear(){
        PROXYCACHE.cleanUp();
    }

    public static Proxy getProxyFromData5u() throws Exception {
        String body = Jsoup.connect(API).ignoreHttpErrors(true).ignoreContentType(true)
                .execute().body();
        if (StringUtils.isBlank(body) || StringUtils.containsIgnoreCase(body, "false")) {
            throw new RuntimeException("获取无忧代理失败");
        }
        String ipAndPort = body.split(",")[0];
        return new Proxy(ipAndPort);
    }

    public static class Proxy {
        private String host;

        private int port;

        public Proxy(String ipAndPort) {
            String[] split = ipAndPort.split(":");
            this.host = split[0];
            this.port = Integer.valueOf(split[1]);
        }

        public String getHost() {
            return host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}
