package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.ImageUtil;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.util.List;

/**
 * @author: sjx
 * @date: 2019-06-11 14:42
 */
public class LiSpider extends AbstractSpider {

    public static final LiSpider SPIDER = new LiSpider();

    private LiSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.LISHIPIN;
    }

    @Override
    public DefaultDto unitedStatesSmash(RequestParam param) {
        Document document = doRequestDocument(param);
        Element body = document.body();
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), getContentSource().getCode());
        String title = body.select("h1").select(".video-tt").text();
        defaultDto.setPostTitle(title);
        String fade = body.select("#poster").select("img").attr("src");
        defaultDto.setImageList(Lists.newArrayList(fade));
        defaultDto.setImages(ImageUtil.listByUrls(defaultDto.getImageList()));
        Elements authorInfo = body.select(".thiscat");
        String name = authorInfo.select(".col-name").text();
        String head = authorInfo.select("img").attr("src");
        String desc = authorInfo.select("a").text();
        DefaultDto.Author author = new DefaultDto.Author(name, head, desc);
        defaultDto.setAuthor(author);
        String text = authorInfo.next().select(".summary").text();
        defaultDto.setSourceAbstract(text);
        String[] strings = StringUtils.splitByWholeSeparator(param.getUrl(), "/");
        String sourceId = strings[strings.length - 1];
        defaultDto.setSourceId(sourceId);
        String s1 = StringUtils.splitByWholeSeparator(document.toString(), "srcUrl=\"")[1];
        String videoUrl = StringUtils.splitByWholeSeparator(s1, "\",")[0];
        defaultDto.setVideoUrl(videoUrl);
        //添加评论
        defaultDto.setComments(getComments(document));
        return defaultDto;
    }

    @Override
    public List<DefaultDto.Comment> getComments(Document document) {
        Elements hotComments = document.body().select(".comm-bd");
        List<DefaultDto.Comment> list = Lists.newArrayList();
        if (hotComments != null && !hotComments.isEmpty()) {
            hotComments.forEach(e -> {
                String style = e.select(".comm-hdimg").attr("style");
                String s = StringUtils.splitByWholeSeparator(style, "url(")[1];
                String head = StringUtils.splitByWholeSeparator(s, ");")[0];
                String name = e.select(".comm-name").select("a").text();
                String text = e.select(".comm-cont").text();
                list.add(new DefaultDto.Comment(text, head, name));
            });
        }
        return list;
    }

    @Override
    protected void checkHost(String url) {
        //do nothing
    }

    public static void main(String[] args) {
        DefaultDto defaultDto = ContentSource.LISHIPIN.getSpider().unitedStatesSmash(new RequestParam("https://www.pearvideo.com/video_1557488"));
        System.err.println(JSON.toJSONString(defaultDto));
    }
}
