package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.ImageUtil;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.exception.ErrorCode;
import cn.com.duiba.spider.util.maiquan.exception.MaiQuanSpiderException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/**
 * 皮皮虾爬虫
 *
 * @author: sjx
 * @date: 2019-05-27 15:51
 */
public class PiPiXiaSpider extends AbstractSpider {

    /**
     * 皮皮虾内容详情查询接口
     */
    private static final String ITEM_DETAIL_URL = "https://h5.pipix.com/bds/webapi/item/detail/?item_id=%s";

    private PiPiXiaSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.PIPIXIA;
    }

    public static final PiPiXiaSpider SPIDER = new PiPiXiaSpider();

    @Override
    public DefaultDto unitedStatesSmash(RequestParam param) {
        //1.判断是否是短链
        String url = param.getUrl();
        String sourceUrl = param.getUrl();
        if (StringUtils.containsIgnoreCase(url, "com/s/")) {
            //将短链转化为长链
            url = doRequest(param).url().toString();
        }
        String itemId = StringUtils.splitByWholeSeparator(StringUtils.splitByWholeSeparator(url, "?")[0], "/item/")[1];
        param.setUrl(String.format(ITEM_DETAIL_URL, itemId));
        JSONObject json = doRequestJSON(param);
        if (json.getIntValue("status_code") != 0) {
            throw new MaiQuanSpiderException(ErrorCode.E005.getCode(), "皮皮虾接口访问失败");
        }
        JSONObject item = json.getJSONObject("data").getJSONObject("item");
        if (item == null) {
            throw new MaiQuanSpiderException(ErrorCode.E004.getCode(), "皮皮虾内容获取失败");
        }
        DefaultDto defaultDto = new DefaultDto(sourceUrl, this.getContentSource().getCode());
        defaultDto.setSourceId(itemId);
        //设置作者信息
        JSONObject author = item.getJSONObject("author");
        String name = author.getString("name");
        String headImg = author.getJSONObject("avatar").getJSONArray("url_list").getJSONObject(0).getString("url");
        defaultDto.setAuthor(new DefaultDto.Author(name, headImg));
        //设置视频信息
        JSONObject video = item.getJSONObject("video");
        if (video != null) {
            String videoUrl = video.getJSONObject("video_high").getJSONArray("url_list").getJSONObject(0).getString("url");
            defaultDto.setVideoUrl(videoUrl);
            defaultDto.setPostTitle(video.getString("text"));
            defaultDto.setSourceAbstract(video.getString("text"));
            JSONArray coverImags = video.getJSONObject("cover_image").getJSONArray("url_list");
            if (CollectionUtils.isNotEmpty(coverImags)) {
                String cover = coverImags.getJSONObject(0).getString("url");
                defaultDto.setImageList(Lists.newArrayList(cover));
            }
        }
        //设置文本和图片信息
        JSONObject note = item.getJSONObject("note");
        if (note != null) {
            defaultDto.setImageList(Lists.newArrayList());
            JSONArray imgs = note.getJSONArray("multi_image");
            String text = note.getString("text");
            if (CollectionUtils.isNotEmpty(imgs)) {
                imgs.forEach(img -> {
                    JSONObject imgJson = JSON.parseObject(img.toString());
                    String imgUrl = imgJson.getJSONArray("url_list").getJSONObject(0).getString("url");
                    defaultDto.getImageList().add(imgUrl);
                });
                defaultDto.setPostTitle(text);
                defaultDto.setSourceAbstract(text);
            } else {
                defaultDto.setPostTitle(StringUtils.substring(text, 0, 20));
                defaultDto.setSourceAbstract(StringUtils.substring(text, 0, 100));
            }
        }

        if (StringUtils.isBlank(defaultDto.getPostTitle())) {
            JSONObject share = item.getJSONObject("share");
            if (share != null) {
                defaultDto.setPostTitle(share.getString("title"));
            }else{
                defaultDto.setPostTitle(sourceUrl);
            }
        }
        defaultDto.setImages(ImageUtil.listByUrls(defaultDto.getImageList()));
        return defaultDto;
    }

    public static void main(String[] args) {
        RequestParam param = new RequestParam("https://h5.pipix.com/s/Mbv8Fh/#");
        DefaultDto defaultDto = ContentSource.PIPIXIA.getSpider().smashOnErrorWithUnknown(param);
        System.err.println(JSON.toJSONString(defaultDto));

        RequestParam param1 = new RequestParam("https://h5.pipix.com/s/MbxBE1/#");
        DefaultDto defaultDto1 = ContentSource.PIPIXIA.getSpider().smashOnErrorWithUnknown(param1);
        System.err.println(JSON.toJSONString(defaultDto1));

        RequestParam param2 = new RequestParam("https://h5.pipix.com/item/6673335339047721219?app_id=1319&app=super&timestamp=1559715008&carrier_region=cn&region=cn&language=zh&utm_source=weixin");
        DefaultDto defaultDto2 = ContentSource.PIPIXIA.getSpider().smashOnErrorWithUnknown(param2);
        System.err.println(JSON.toJSONString(defaultDto2));
    }

    @Override
    protected void checkHost(String url) {
        //do nothing
    }
}
