package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.ImageUtil;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/**
 * @author: sjx
 * @date: 2019-05-29 16:43
 */
public class TiaoBaSpider extends AbstractSpider {

    public static final TiaoBaSpider SPIDER = new TiaoBaSpider();

    private TiaoBaSpider() {

    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.TIAOBA;
    }

    @Override
    public DefaultDto unitedStatesSmash(RequestParam param) {
        Document document = doRequestDocument(param);
        Elements body = document.select("body");
        Element top = body.select("section").select("#top").get(0);
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), getContentSource().getCode());
        String title = top.select(".details").select("p").get(0).text();
        defaultDto.setSourceAbstract(title);
        defaultDto.setPostTitle(title);
        defaultDto.setVideoUrl(top.select("video").get(0).attr("src"));
        String fade = top.select("img").select(".fade").attr("src");
        defaultDto.setImageList(Lists.newArrayList(fade));
        String[] path = StringUtils.splitByWholeSeparator(param.getUrl(), "/");
        defaultDto.setSourceId(path[path.length - 1]);
        if (StringUtils.isBlank(defaultDto.getPostTitle())) {
            defaultDto.setPostTitle(param.getUrl());
        }
        defaultDto.setImages(ImageUtil.listByUrls(defaultDto.getImageList()));
        return defaultDto;
    }

    @Override
    protected void checkHost(String url) {
        //do nothing
    }

    public static void main(String[] args) {
        DefaultDto defaultDto = ContentSource.TIAOBA.getSpider().unitedStatesSmash(new RequestParam("http://app.tiaoba360.com/Home/Video/index/id/135531"));
        System.err.println(JSON.toJSONString(defaultDto));
    }
}
