package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.ImageUtil;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

/**
 * 头条摄影集
 *
 * @author: sjx
 * @date: 2019-06-12 14:30
 */
public class TouTiaoPicSpider extends AbstractSpider {

    public static final TouTiaoPicSpider SPIDER = new TouTiaoPicSpider();

    private TouTiaoPicSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.TOUTIAOSHEYING;
    }

    @Override
    public DefaultDto unitedStatesSmash(RequestParam param) {
        String html = doRequestString(param);
        String url = param.getUrl();
        if (StringUtils.endsWith(url, "/")) {
            url = StringUtils.substring(url, 0, url.length() - 1);
        }
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), ContentSource.TOUTIAOSHEYING.getCode());
        String[] strings = StringUtils.splitByWholeSeparator(url, "/");
        String sid = strings[strings.length - 1];
        defaultDto.setSourceId(sid);
        String userStr = html.split("mediaInfo:")[1].split("},")[0] + "}";
        JSONObject user = JSON.parseObject(userStr);
        String avatarUrl = user.getString("avatarUrl");
        if (StringUtils.startsWith(avatarUrl, "//")) {
            avatarUrl = "http:" + avatarUrl;
        }
        defaultDto.setAuthor(new DefaultDto.Author(user.getString("name"), avatarUrl));
        String dataStr = html.split("BASE_DATA.galleryInfo = ")[1].split("</script>")[0];
        String title = StringUtils.splitByWholeSeparator(StringUtils.splitByWholeSeparator(dataStr, "title: '")[1], "',")[0];
        defaultDto.setPostTitle(title);
        defaultDto.setSourceAbstract(title);
        String gallery = StringUtils.splitByWholeSeparator(StringUtils.splitByWholeSeparator(dataStr, "JSON.parse(\"")[1], "\"),")[0];
        gallery = gallery.replaceAll("\\\\", "");
        JSONObject imgs = JSON.parseObject(gallery);
        JSONArray sub_images = imgs.getJSONArray("sub_images");
        if (sub_images == null || sub_images.isEmpty()) {
            return null;
        }
        defaultDto.setImageList(Lists.newArrayList());
        for (int i = 0; i < sub_images.size(); i++) {
            JSONObject img = sub_images.getJSONObject(i);
            String imgUrl = img.getString("url");
            if (StringUtils.isNotBlank(imgUrl)) {
                defaultDto.getImageList().add(imgUrl);
            }
        }
        defaultDto.setImages(ImageUtil.listByUrls(defaultDto.getImageList()));
        defaultDto.setContentType("0");
        return defaultDto;
    }

    @Override
    protected void checkHost(String url) {
        //do nothing
    }

    public static void main(String[] args) {
        DefaultDto defaultDto = ContentSource.TOUTIAOSHEYING.getSpider().unitedStatesSmash(new RequestParam("https://www.toutiao.com/i6701224749957120516/"));
        System.err.println(JSON.toJSONString(defaultDto));
    }
}
