package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.ImageUtil;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

/**
 * @author: Administrator
 * @date: 2019-07-11 16:21
 */
@Deprecated
public class XiGuaVideoSpider extends AbstractSpider {

    public static final XiGuaVideoSpider SPIDER = new XiGuaVideoSpider();

    private XiGuaVideoSpider() {

    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.XIGUA;
    }

    @Override
    public DefaultDto unitedStatesSmash(RequestParam param) {
        Document doc = doRequestDocument(param);
        String url = param.getUrl();
        DefaultDto defaultDto = new DefaultDto(url, getContentSource().getCode());
        String title = doc.head().select("title").text();
        defaultDto.setPostTitle(title);
        defaultDto.setContentType("0");
        defaultDto.setSourceAbstract(title);
        defaultDto.setVideoUrl(url);
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        String[] split = url.split("/");
        defaultDto.setSourceId(split[split.length - 1]);
        Elements userDiv = doc.body().select("div").select(".videoDesc__userinfo");
        Elements userInfo = userDiv.select("a").select(".component-avatar__inner");
        String userName = userInfo.attr("title");
        try {
            String html = doc.html();
            String cover = html.split("\"cover_url\":\"")[1].split("\",")[0];
            defaultDto.setImageList(Lists.newArrayList(cover));
            defaultDto.setImages(ImageUtil.listByUrls(defaultDto.getImageList()));
            String style = userInfo.attr("style");
            String headImg = "http:" + style.split("url\\(")[1].split("\\)")[0];
            defaultDto.setAuthor(new DefaultDto.Author(userName, headImg));
        } catch (Exception e) {
            //do nothing
        }
        return defaultDto;
    }

    public static void main(String[] args) {
        DefaultDto defaultDto = SPIDER.unitedStatesSmash(new RequestParam("https://www.ixigua.com/i6702308019285279243"));
        System.err.println(JSON.toJSONString(defaultDto));
    }

    @Override
    protected void checkHost(String url) {
        //do nothing
    }
}
