package cn.com.duiba.spider.util.maiquan.tts.baidu.keyword;

import cn.com.duiba.spider.util.maiquan.tts.baidu.common.TokenHolder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: Administrator
 * @date: 2019-07-02 15:25
 */
public class BaiduKeywordUtil {

    private static final String API_URL = "https://aip.baidubce.com/rpc/2.0/nlp/v1/keyword?charset=UTF-8&access_token=%s";

    private static final TokenHolder TOKEN_HOLDER = new TokenHolder("NG08AwHezOTKpXUcQAzeSkw5", "KLDuiOMg6f60mw7s5eXm8LjxPwHrkjGK", "");

    public static Tags tag4Text(String title, String content) throws IOException {
        if (StringUtils.isBlank(title) || StringUtils.isBlank(content)) {
            return new Tags(Lists.newArrayList(), Lists.newArrayList());
        }
        TextReq textReq = new TextReq(title, content);
        String body = Jsoup.connect(String.format(API_URL, TOKEN_HOLDER.refresh())).ignoreContentType(true).ignoreHttpErrors(true)
                .requestBody(JSON.toJSONString(textReq)).method(Connection.Method.POST)
                .timeout(5000).execute().body();
        JSONObject result = JSON.parseObject(body);
        if (result == null || !result.containsKey("items")) {
            return new Tags(Lists.newArrayList(), Lists.newArrayList());
        }
        JSONArray items = result.getJSONArray("items");
        List<String> tags = Lists.newArrayList();
        List<Keyword> keywords = items.stream()
                .map(i -> {
                    Keyword keyword = JSON.parseObject(i.toString(), Keyword.class);
                    tags.add(keyword.getTag());
                    return keyword;
                }).collect(Collectors.toList());

        return new Tags(tags, keywords);
    }

    public static void main(String[] args) throws IOException {
        Tags tags = tag4Text("iphone手机出现“白苹果”原因及解决办法，用苹果手机的可以看下", "如果下面的方法还是没有解决你的问题建议来我们门店看下成都市锦江区红星路三段99号银石广场24层01室。在通电的情况下掉进清水，这种情况一不需要拆机处理。尽快断电。用力甩干，但别把机器甩掉，主意要把屏幕内的水甩出来。如果屏幕残留有水滴，干后会有痕迹。^H3 放在台灯，射灯等轻微热源下让水分慢慢散去。");
        System.err.println(JSON.toJSONString(tags));
    }

    static class TextReq {
        private String title;

        private String content;

        public TextReq(String title, String content) {
            this.title = title;
            this.content = content;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }

    public static class Tags {
        //标签文案集合
        private List<String> tags;

        //标签对象集合
        private List<Keyword> keywords;

        public Tags(List<String> tags, List<Keyword> keywords) {
            this.tags = tags;
            this.keywords = keywords;
        }

        public List<String> getTags() {
            return tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public List<Keyword> getKeywords() {
            return keywords;
        }

        public void setKeywords(List<Keyword> keywords) {
            this.keywords = keywords;
        }
    }

    public static class Keyword {
        //权重
        private String score;

        //标签
        private String tag;

        public String getScore() {
            return score;
        }

        public void setScore(String score) {
            this.score = score;
        }

        public String getTag() {
            return tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }
}
