package cn.com.duiba.spider.util.maiquan.tts.baidu.speech.restapi.ttsdemo;

import cn.com.duiba.spider.util.maiquan.tts.baidu.common.ConnUtil;
import cn.com.duiba.spider.util.maiquan.tts.baidu.common.DemoException;
import cn.com.duiba.spider.util.maiquan.tts.baidu.common.TokenHolder;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

public class TtsMain {

    public static void main(String[] args) throws IOException, DemoException {
        (new TtsMain()).run();
    }

    //  填写网页上申请的appkey 如 $apiKey="g8eBUMSokVB1BHGmgxxxxxx"
    private final String appKey = "6yWVLbLqTr3M6Fn4hKGDCYoq";

    // 填写网页上申请的APP SECRET 如 $secretKey="94dc99566550d87f8fa8ece112xxxxx"
    private final String secretKey = "6UR5uRoPzFEZE8lBaExEs2HyxdMdchtB";

    // text 的内容为"欢迎使用百度语音合成"的urlencode,utf-8 编码
    // 可以百度搜索"urlencode"
    private final String text = "六月末，七月初。\n" +
            "大学里可人小哥哥小姐姐都出校门了，鱼一样朝我们涌来，活蹦乱跳，艳艳生花。\n" +
            "有读者问我：能不能写一篇关于毕业生毕业之后的社会生存指南，实在点，有用点，说得根本点。我说，好。\n" +
            "2016年这个时候，我从学校毕业，大包小包，一箱子书，从北方拉到南方，去一家巨型企业做管培生。\n" +
            "呆了3个月，我还是适应不了这家巨型企业的企业套路和圈子文化。转正了，离职了。\n" +
            "2017年差不多这个时候，再往后一点，我出版了自己的第一本书，西藏游记。\n" +
            "大概花了半年时间写这本书，每天写到十二点，菠萝啤和小炒肉，脑子里想着小姐姐，把一路的风花雪月都敲下来。\n" +
            "2019年，这个时候再往前一点，我拉着许天出来创业，成立了我们第一家公司。\n" +
            "这份指南，基于我自己对生活，对财富，对职业的理解。\n" +
            "也许已经找到工作，确定了要去的地方，也许还没有。都没关系，都可以看看。\n" +
            "这份指南，长期有用。1、体制外未必比体制内好\n" +
            " \n" +
            "长期以来，长期流行的一种观点是：\n" +
            " \n" +
            "体制外好，你的努力，立竿见影，有能力，薪水立刻就能上去。\n" +
            "而且，体制外自由。\n" +
            "人力也是一种资源，这种资源按照市场配置原则，会找到它适合的价位。\n" +
            " \n" +
            "体制内就不一定了：\n" +
            " \n" +
            "层级多而繁杂，关系硬比能力硬更重要。\n" +
            "不自由，随便一个比你官大的都能管着你。\n" +
            "薪资涨幅慢，公务员普遍调薪，要中组部审批，最终造成的结果可能会是，你和同学一起毕业，一起工资5000起，三年后，体制外的涨到了一万五，你还是五千。\n" +
            " \n" +
            "这是偏见。\n" +
            "如果你看新闻看得多，你会发现，所谓中年危机，一般都是只体制外的人群，所谓性别就业歧视，大部分也是针对体制外而言。\n" +
            " \n" +
            "体制内有体制外不可比拟的优势：\n" +
            "你工作再差劲，完成度再低，领导骂你再骂个狗血淋头，你至少不会被通知去财务处结账走人。\n" +
            "该给你的婚假产假，除非特殊情况，一般是会给的，并且不会因此就少发你工资。\n" +
            " \n" +
            "体制内还是体制外，无非是一种选择。\n" +
            "选择体制内，就选择了稳定，未必大富大贵，但生活基本小康，社会地位未必极高，但基本受人尊重。\n" +
            "选择体制外，就选择了沉浮，生活高度自由，每个选择都可以自己来，除了法律和基本人情世故，没有束缚，与此相对应，你也得承担高度自由带来的责任。你可能会混的很好，也可能会混得很不好。\n" +
            " \n" +
            "体制内也有很著名的斜杠青年，例如写《三体》的刘慈欣，例如写《明朝那些事儿》的当年明月，例如六神磊磊。\n" +
            " \n" +
            "你问我，毕业了，去体制内还是体制外，我的回答是：\n" +
            " \n" +
            "因人看事。\n" +
            "\n" +
            "主要看你。\n" +
            " \n" +
            "写下这条指南，并不是要给你明确答案，而是想破除你某些偏见，尤其是对体制内的偏见。\n" +
            "把思考原点重新拉回平衡位置。\n" +
            " \n" +
            "2、城市比工作重要\n" +
            " \n" +
            "如果犹豫不决，如果可以选，家乡小县城和广州，选哪座城市？\n" +
            "我的看法是：\n" +
            " \n" +
            "要坚定不移地选广州。\n" +
            "\n" +
            "当然，这个前提是，你可以选，你犹豫不绝。\n" +
            "如果你已经铁了心要去某座城市，非此地不活，那么，听从你内心的想法。\n" +
            "人不要做让自己很为难的事情。\n" +
            " \n" +
            "很多时候，就职业角度来说，选择一座城市，比选择一份工作，更重要。\n" +
            " \n" +
            "从2008年到2018年，广州市中心珠江新城的房价，从8000涨到十万，涨幅超过10倍；同样是这10年间，我老家县城的房价，不到一千涨四千，涨幅五六倍。\n" +
            "你可以看到，广州房产的升值幅度，明显大于小县城。\n" +
            " \n" +
            "房子是什么？拆解来看，不过就是若干钢筋混泥土，若干砖块。\n" +
            "同样是若干钢筋混泥土和若干砖块，为什么广州的房子那么值钱？\n" +
            "李嘉诚的话：买房子，就是买地段。\n" +
            " \n" +
            "广州是整个华南甚至是东南亚的广州，人口、资金、都是全国范围的。\n" +
            "家乡县城就是那个县城及其乡镇的县城，人口、资金来源，范围极小。\n" +
            " \n" +
            "同样的道理。\n" +
            "人是什么？拆解来看，人就是若干组织细胞，若干器官系统。\n" +
            "再去翻翻全国各地毕业生工资水平，为什么有些城市，天然高，天然更高？\n" +
            "这是我的答案：\n" +
            " \n" +
            "城市资源对个体的赋能能力不同。\n" +
            "\n" +
            "一座城市，会对到这座城市的人，进行赋能。\n" +
            "城市资源不同，赋能能力就有差异。\n" +
            " \n" +
            "选择一座城市，潜心下来，好好工作，和这座城市共同成长，城市也会反哺于你。\n" +
            " \n" +
            "3、工作选择法则\n" +
            " \n" +
            "如何挑选工作？\n" +
            "第一法则，当然是挑选让自己开心或者至少不让自己为难的工作。\n" +
            "做一份工作，你天天骂街，天天嫌弃自己，日子也太难过了，不如辞职。\n" +
            " \n" +
            "第二法则，挑选边际成本低的工作。\n" +
            " \n" +
            "这里普及一个经济学概念，边际成本。\n" +
            "所谓边际成本，通俗来说，就是你服务一群客户，客户群体不断扩大，但你付出的成本基本不变。\n" +
            "举个例子。\n" +
            "我写文章，一天一篇。\n" +
            "我的公众号有20万读者，我的工作量是一天一篇；\n" +
            "我的公众号有100万读者（希望我的公众号可以快点100万读者哈哈哈），我的工作量也是一天一篇，生产成本基本不变。\n" +
            "但20万读者和100万读者产生的收益，完全不一样。\n" +
            " \n" +
            "具体来说，互联网作为一个行业，极大降低了边际成本。\n" +
            "尽管各类人还在吹嘘互联网泡沫，尽管各类媒体依然很悲观地看互联网产业，我还是乐观地看待这个行业，因为没有哪个行业，比它的边际成本更低。\n";

    // 发音人选择, 0为普通女声，1为普通男生，3为情感合成-度逍遥，4为情感合成-度丫丫，默认为普通女声
    private final int per = 3;
    // 语速，取值0-15，默认为5中语速
    private final int spd = 5;
    // 音调，取值0-15，默认为5中语调
    private final int pit = 5;
    // 音量，取值0-9，默认为5中音量
    private final int vol = 5;

    // 下载的文件格式, 3：mp3(default) 4： pcm-16k 5： pcm-8k 6. wav
    private final int aue = 3;

    public final String url = "http://tsn.baidu.com/text2audio"; // 可以使用https

    private String cuid = "16591712";

    private void run() throws IOException, DemoException {
        TokenHolder holder = new TokenHolder(appKey, secretKey, TokenHolder.ASR_SCOPE);
        String token = holder.refresh();

        // 此处2次urlencode， 确保特殊字符被正确编码
        System.err.println(text.length());
        String params = "tex=" + ConnUtil.urlEncode(ConnUtil.urlEncode(text));
        params += "&per=" + per;
        params += "&spd=" + spd;
        params += "&pit=" + pit;
        params += "&vol=" + vol;
        params += "&cuid=" + cuid;
        params += "&tok=" + token;
        params += "&aue=" + aue;
        params += "&lan=zh&ctp=1";
        System.out.println(url + "?" + params); // 反馈请带上此url，浏览器上可以测试
        HttpURLConnection conn = (HttpURLConnection) new URL(url).openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setConnectTimeout(5000);
        PrintWriter printWriter = new PrintWriter(conn.getOutputStream());
        printWriter.write(params);
        printWriter.close();
        String contentType = conn.getContentType();
        if (contentType.contains("audio/")) {
            byte[] bytes = ConnUtil.getResponseBytes(conn);
            String format = getFormat(aue);
            File file = new File("result." + format); // 打开mp3文件即可播放
            // System.out.println( file.getAbsolutePath());
            FileOutputStream os = new FileOutputStream(file);
            os.write(bytes);
            os.close();
            System.out.println("audio file write to " + file.getAbsolutePath());
        } else {
            System.err.println("ERROR: content-type= " + contentType);
            String res = ConnUtil.getResponseString(conn);
            System.err.println(res);
        }
    }

    // 下载的文件格式, 3：mp3(default) 4： pcm-16k 5： pcm-8k 6. wav
    private String getFormat(int aue) {
        String[] formats = {"mp3", "pcm", "pcm", "wav"};
        return formats[aue - 3];
    }
}
