package cn.com.duiba.spider.util.maiquan.tts.baidu.summary;

import cn.com.duiba.spider.util.maiquan.tts.baidu.common.TokenHolder;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

import java.io.IOException;

/**
 * @author: Administrator
 * @date: 2019-07-04 17:17
 */
public class BaiduSummaryUtil {

    private static final int MAX_LENGTH = 300;

    private static final int RETURN_LENGTH = 150;

    private static final String API_URL = "https://aip.baidubce.com/rpc/2.0/nlp/v1/news_summary?charset=UTF-8&access_token=%s";

    private static final TokenHolder TOKEN_HOLDER = new TokenHolder("NG08AwHezOTKpXUcQAzeSkw5", "KLDuiOMg6f60mw7s5eXm8LjxPwHrkjGK", "");

    public static String summary4Text(String title, String text, int length, int returnLength) {
        if (StringUtils.isBlank(title) || StringUtils.isBlank(text)) {
            return "";
        }
        try {
            String url = String.format(API_URL, TOKEN_HOLDER.refresh());
            length = length <= 0 ? MAX_LENGTH : length;
            returnLength = returnLength <= 0 ? RETURN_LENGTH : returnLength;
            SummaryReq summaryReq = new SummaryReq(title, text, length);
            String body = Jsoup.connect(url).ignoreHttpErrors(true).ignoreContentType(true)
                    .timeout(5000).requestBody(summaryReq.toString())
                    .method(Connection.Method.POST)
                    .execute()
                    .body();
            String summary = JSON.parseObject(body).getString("summary");
            if (StringUtils.isBlank(summary)) {
                return "";
            }
            if (summary.length() > returnLength) {
                return summary.substring(0, returnLength);
            } else {
                return summary;
            }
        } catch (Exception e) {

        }
        return "";
    }

    public static String summary4Text(String title, String text) {
        return summary4Text(title, text, MAX_LENGTH, RETURN_LENGTH);
    }


    private static class SummaryReq {

        private String title;

        private String content;

        private int max_summary_len;

        public SummaryReq(String title, String content, int max_summary_len) {
            this.title = title;
            this.content = content;
            this.max_summary_len = max_summary_len;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public int getMax_summary_len() {
            return max_summary_len;
        }

        public void setMax_summary_len(int max_summary_len) {
            this.max_summary_len = max_summary_len;
        }

        @Override
        public String toString() {
            return JSON.toJSONString(this);
        }
    }
}
