/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;

public class MaiQuanSpiderUtil {
    private MaiQuanSpiderUtil() {
    }

    public static ContentSource resloveSourceByUrl(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            String host = StringUtils.split((String)url, (String)"?")[0];
            if (StringUtils.indexOf((String)host, (String)"www.meipian") > -1) {
                return ContentSource.MEIPIAN;
            }
            if (StringUtils.indexOf((String)host, (String)"mp.weixin.qq.com") > -1) {
                return ContentSource.GONGZHONGHAO;
            }
            if (StringUtils.indexOf((String)host, (String)"pipix.com") > -1 || StringUtils.indexOf((String)host, (String)"ppx.ixigua.com") > -1) {
                return ContentSource.PIPIXIA;
            }
            if (StringUtils.indexOf((String)host, (String)"http://app.tiaoba360.com") > -1) {
                return ContentSource.TIAOBA;
            }
            if (StringUtils.indexOf((String)host, (String)"//www.pearvideo.com") > -1) {
                return ContentSource.LISHIPIN;
            }
        }
        return ContentSource.UNKNOWN;
    }

    public static DefaultDto smash(AbstractSpider.RequestParam param) {
        return MaiQuanSpiderUtil.resloveSourceByUrl(param.getUrl()).getSpider().unitedStatesSmash(param);
    }

    public static DefaultDto smash(String url) {
        return MaiQuanSpiderUtil.smash(new AbstractSpider.RequestParam(url));
    }

    public static DefaultDto smashOnErrorWithUnknown(AbstractSpider.RequestParam param) {
        return MaiQuanSpiderUtil.resloveSourceByUrl(param.getUrl()).getSpider().smashOnErrorWithUnknown(param);
    }

    public static DefaultDto smashOnErrorWithUnknown(String url) {
        return MaiQuanSpiderUtil.smashOnErrorWithUnknown(new AbstractSpider.RequestParam(url));
    }

    public static void main(String[] args) {
        AbstractSpider.RequestParam param2 = new AbstractSpider.RequestParam("https://mp.weixin.qq.com/s/UPQ2Ok2vcYAnta1USOTyQw");
        DefaultDto smash2 = MaiQuanSpiderUtil.smash(param2);
        System.err.println(JSON.toJSONString((Object)smash2));
    }
}

