/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan;

import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;

public class ImageUtil {
    public static DefaultDto.Image getByUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            BufferedImage read = ImageIO.read(new URL(url));
            read.flush();
            if (read.getHeight() >= 300 && read.getWidth() >= 300) {
                return new DefaultDto.Image(read.getHeight(), read.getWidth(), url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static List<DefaultDto.Image> listByUrls(Collection<String> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return Lists.newArrayList();
        }
        ArrayList images = Lists.newArrayList();
        urls.forEach(url -> {
            DefaultDto.Image byUrl = ImageUtil.getByUrl(url);
            if (byUrl != null) {
                images.add(byUrl);
            }
        });
        return images;
    }

    public static void main(String[] args) throws IOException {
        System.err.println(JSON.toJSONString((Object)ImageUtil.getByUrl("http://static.zhihu.com/static/favicon.ico")));
        BufferedInputStream bs = Jsoup.connect((String)"http://static.zhihu.com/static/favicon.ico").ignoreContentType(true).ignoreHttpErrors(true).execute().bodyStream();
        BufferedImage read = ImageIO.read(bs);
        System.err.println(read.getHeight());
    }
}

