/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.ImageUtil;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.exception.ErrorCode;
import cn.com.duiba.spider.util.maiquan.exception.MaiQuanSpiderException;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import cn.com.duiba.spider.util.maiquan.tts.TextUtil;
import cn.com.duiba.spider.util.maiquan.tts.baidu.keyword.BaiduKeywordUtil;
import cn.com.duiba.spider.util.maiquan.tts.baidu.summary.BaiduSummaryUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GongZhongHaoSpider
extends AbstractSpider {
    public static final GongZhongHaoSpider SPIDER = new GongZhongHaoSpider();

    private GongZhongHaoSpider() {
    }

    @Override
    public ContentSource getContentSource() {
        return ContentSource.GONGZHONGHAO;
    }

    @Override
    public DefaultDto unitedStatesSmash(AbstractSpider.RequestParam param) {
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), this.getContentSource().getCode());
        Document document = this.doRequestDocument(param);
        Elements bodyDivs = document.body().select("div");
        String authorName = bodyDivs.select(".profile_nickname").text();
        defaultDto.setAuthor(new DefaultDto.Author(authorName, ""));
        Elements titleElement = bodyDivs.select(".rich_media_title");
        if (CollectionUtils.isEmpty((Collection)titleElement)) {
            throw new MaiQuanSpiderException(ErrorCode.E004.getCode(), "\u516c\u4f17\u53f7\u6587\u7ae0\u6807\u9898\u83b7\u53d6\u5931\u8d25");
        }
        String title = titleElement.text();
        defaultDto.setPostTitle(title);
        defaultDto.setSourceId(DigestUtils.md5Hex((String)title));
        Elements select = bodyDivs.select(".rich_media_content");
        if (CollectionUtils.isEmpty((Collection)select)) {
            throw new MaiQuanSpiderException(ErrorCode.E004.getCode(), "\u516c\u4f17\u53f7\u6587\u7ae0\u5185\u5bb9\u83b7\u53d6\u5931\u8d25");
        }
        Element content = (Element)select.get(0);
        List<String> imgs = content.select("img").stream().map(o -> o.attr("data-src")).filter(s -> !StringUtils.containsIgnoreCase((String)s, (String)"mmbiz_gif") && !StringUtils.containsIgnoreCase((String)s, (String)"wx_fmt=gif")).collect(Collectors.toList());
        defaultDto.setImageList(imgs);
        defaultDto.setImages(ImageUtil.listByUrls(imgs));
        ArrayList list = Lists.newArrayList();
        this.text4Elements(select, list);
        StringBuilder sb = new StringBuilder(title).append("\u3002");
        list.forEach(s -> sb.append((String)s));
        defaultDto.setFullText(sb.toString());
        defaultDto.setSourceAbstract(BaiduSummaryUtil.summary4Text(title, sb.toString()));
        try {
            defaultDto.setTags(BaiduKeywordUtil.tag4Text(defaultDto.getPostTitle(), defaultDto.getFullText()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return defaultDto;
    }

    private void text4Elements(Elements e, List<String> texts) {
        for (Element element : e) {
            String text = element.text();
            if (!StringUtils.isNotBlank((String)text)) continue;
            texts.add(TextUtil.joinSplitor4Text(text));
        }
    }

    @Override
    protected void checkHost(String url) {
    }

    public static void main(String[] args) {
        DefaultDto defaultDto = ContentSource.GONGZHONGHAO.getSpider().unitedStatesSmash(new AbstractSpider.RequestParam("https://mp.weixin.qq.com/s?__biz=MjM5NTQyMjA4MA==&mid=2650874188&idx=1&sn=7e7db36953526edb9f094d63abaef9a1&chksm=bd0d4ba38a7ac2b5f746581ae4e8df13fb5cd65afb5943469531f049a91a6865a7aeca66bbaf"));
        System.err.println(JSON.toJSONString((Object)defaultDto));
    }
}

