/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.ImageUtil;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.exception.ErrorCode;
import cn.com.duiba.spider.util.maiquan.exception.MaiQuanSpiderException;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import cn.com.duiba.spider.util.maiquan.tts.TextUtil;
import cn.com.duiba.spider.util.maiquan.tts.baidu.keyword.BaiduKeywordUtil;
import cn.com.duiba.spider.util.maiquan.tts.baidu.summary.BaiduSummaryUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MeiPianSpider
extends AbstractSpider {
    private static final String COMMENT_URL = "https://poster.meipian.cn/4.5/comment/list";
    private static final String COMMENT_PARAM = "{\"access\":\"1000|guest\",\"con\":\"comment\",\"fn\":\"listV2\",\"article_id\":\"%s\",\"wuser_id\":0,\"max_id\":0,\"size\":20}";
    public static final MeiPianSpider SPIDER = new MeiPianSpider();

    private MeiPianSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.MEIPIAN;
    }

    @Override
    public DefaultDto unitedStatesSmash(AbstractSpider.RequestParam param) {
        Document document = this.doRequestDocument(param);
        Elements bodyDivs = document.body().select("div");
        Element articleMeta = bodyDivs.select(".article-meta").first();
        if (articleMeta == null) {
            throw new MaiQuanSpiderException(ErrorCode.E004.getCode(), "\u7f8e\u7bc7\u6587\u7ae0\u6807\u9898\u83b7\u53d6\u5931\u8d25");
        }
        Elements sections = bodyDivs.select(".content-container").select(".section");
        if (sections.size() <= 0) {
            throw new MaiQuanSpiderException(ErrorCode.E004.getCode(), "\u7f8e\u7bc7\u6587\u7ae0\u5185\u5bb9\u83b7\u53d6\u5931\u8d25");
        }
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), this.getContentSource().getCode());
        Element authorInfo = bodyDivs.select(".pc_right_bar").select(".authermessage").first();
        String style = authorInfo.select(".autherheader").first().attr("style");
        String s = StringUtils.splitByWholeSeparator((String)style, (String)"(")[1];
        String headImg = StringUtils.splitByWholeSeparator((String)s, (String)")")[0];
        String nickname = authorInfo.select(".authernickname").text();
        defaultDto.setAuthor(new DefaultDto.Author(nickname, headImg));
        ArrayList imgList = Lists.newArrayList();
        defaultDto.setImageList(imgList);
        String title = articleMeta.select("h1").select(".title").html();
        defaultDto.setPostTitle(title);
        String path = StringUtils.splitByWholeSeparator((String)param.getUrl(), (String)"//")[1];
        String[] strings = StringUtils.splitByWholeSeparator((String)path, (String)"/");
        defaultDto.setSourceId(strings[strings.length - 1]);
        defaultDto.setVideoUrl("");
        StringBuilder sb = new StringBuilder(TextUtil.joinSplitor4Text(title));
        sections.forEach(section -> {
            Elements imgs = section.select(".img-box").select("img");
            imgs.forEach(img -> imgList.add(img.attr("src")));
            Elements texts = section.select(".text");
            if (CollectionUtils.isNotEmpty((Collection)texts)) {
                sb.append(TextUtil.joinSplitor4Text(texts.text()));
            }
        });
        defaultDto.setSourceAbstract(BaiduSummaryUtil.summary4Text(title, sb.toString()));
        defaultDto.setImages(ImageUtil.listByUrls(imgList));
        defaultDto.setFullText(sb.toString());
        AbstractSpider.RequestParam commentParam = new AbstractSpider.RequestParam(COMMENT_URL, Connection.Method.POST);
        commentParam.setBody(String.format(COMMENT_PARAM, defaultDto.getSourceId()));
        defaultDto.setComments(this.getComments(commentParam));
        try {
            defaultDto.setTags(BaiduKeywordUtil.tag4Text(defaultDto.getPostTitle(), defaultDto.getFullText()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return defaultDto;
    }

    @Override
    public List<DefaultDto.Comment> getComments(AbstractSpider.RequestParam param) {
        JSONObject json = this.doRequestJSON(param);
        JSONArray comments = json.getJSONArray("comments");
        ArrayList list = Lists.newArrayList();
        if (comments != null && !comments.isEmpty()) {
            for (int i = 0; i < comments.size(); ++i) {
                JSONObject c = comments.getJSONObject(i);
                String text = c.getString("comment");
                String head = c.getString("head_img_url");
                String name = c.getString("nickname");
                DefaultDto.Comment comment = new DefaultDto.Comment(text, head, name);
                list.add(comment);
            }
        }
        return list;
    }

    @Override
    protected void checkHost(String url) {
    }

    public static void main(String[] args) {
        DefaultDto defaultDto = ContentSource.MEIPIAN.getSpider().unitedStatesSmash(new AbstractSpider.RequestParam("https://www.meipian.cn/273gk4hd"));
        System.err.println(JSON.toJSONString((Object)defaultDto));
    }
}

