/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class SougouWeiXinSpider
extends AbstractSpider {
    public static final SougouWeiXinSpider SPIDER = new SougouWeiXinSpider();
    private static final String SOUGOU_HOST = "https://weixin.sogou.com";
    private static final String SOUGOU_URL = "https://weixin.sogou.com/weixin?type=2&s_from=input&query=%s&ie=utf8";
    private static final int K = 51;
    private static final String RANDOM_PARAM = "&k=51&h=%s";

    private SougouWeiXinSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.SOUGOUWEIXIN;
    }

    @Override
    public DefaultDto unitedStatesSmash(AbstractSpider.RequestParam param) {
        throw new RuntimeException("\u4e0d\u652f\u6301\u65b9\u6cd5");
    }

    @Override
    public List<DefaultDto> unitedStatesSmashPlus(AbstractSpider.RequestParam param) {
        param.setUrl(String.format(SOUGOU_URL, param.getUrl()));
        Document document = this.doRequestDocument(param);
        Elements lis = document.body().select(".news-list").select("li");
        if (lis == null || lis.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList defaultDtos = Lists.newArrayList();
        lis.forEach(li -> {
            try {
                String imgSrc = "https://" + StringEscapeUtils.unescapeHtml((String)li.select("img").attr("src"));
                String title = li.select("h3").select("a").text();
                String path = li.select("h3").select("a").attr("href");
                String text = li.select(".txt-info").text();
                DefaultDto defaultDto = new DefaultDto(SougouWeiXinSpider.addRandomParam(SOUGOU_HOST + path), ContentSource.SOUGOUWEIXIN.getCode());
                defaultDto.setReferer(param.getUrl());
                defaultDto.setPostTitle(title);
                defaultDto.setSourceAbstract(text);
                defaultDto.setContentType("0");
                defaultDto.setImageList(Lists.newArrayList((Object[])new String[]{imgSrc}));
                defaultDtos.add(defaultDto);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return defaultDtos;
    }

    private static String addRandomParam(String url) {
        int i = StringUtils.indexOf((String)url, (String)"url=") + 51 + 30;
        String substring = url.substring(i, i + 1);
        return url + String.format(RANDOM_PARAM, substring);
    }

    @Override
    protected void checkHost(String url) {
    }
}

