/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.ImageUtil;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class TiaoBaSpider
extends AbstractSpider {
    public static final TiaoBaSpider SPIDER = new TiaoBaSpider();

    private TiaoBaSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.TIAOBA;
    }

    @Override
    public DefaultDto unitedStatesSmash(AbstractSpider.RequestParam param) {
        Document document = this.doRequestDocument(param);
        Elements body = document.select("body");
        Element top = (Element)body.select("section").select("#top").get(0);
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), this.getContentSource().getCode());
        String title = ((Element)top.select(".details").select("p").get(0)).text();
        defaultDto.setSourceAbstract(title);
        defaultDto.setPostTitle(title);
        defaultDto.setVideoUrl(((Element)top.select("video").get(0)).attr("src"));
        String fade = top.select("img").select(".fade").attr("src");
        defaultDto.setImageList(Lists.newArrayList((Object[])new String[]{fade}));
        String[] path = StringUtils.splitByWholeSeparator((String)param.getUrl(), (String)"/");
        defaultDto.setSourceId(path[path.length - 1]);
        if (StringUtils.isBlank((String)defaultDto.getPostTitle())) {
            defaultDto.setPostTitle(param.getUrl());
        }
        defaultDto.setImages(ImageUtil.listByUrls(defaultDto.getImageList()));
        return defaultDto;
    }

    @Override
    protected void checkHost(String url) {
    }

    public static void main(String[] args) {
        DefaultDto defaultDto = ContentSource.TIAOBA.getSpider().unitedStatesSmash(new AbstractSpider.RequestParam("http://app.tiaoba360.com/Home/Video/index/id/135531"));
        System.err.println(JSON.toJSONString((Object)defaultDto));
    }
}

