/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;

public class UnknownSpider
extends AbstractSpider {
    private static final String DEFAULT_ICON = "https://yun.duiba.com.cn/magic/link_icon.png";
    private static final String IXIGUA_ICON = "https://yun.duiba.com.cn/magic/ixigua.png";
    private static final String ZHIHU_ICON = "https://yun.duiba.com.cn/magic/zhihu.png";
    private static final String TANGDOU_ICON = "https://yun.duiba.com.cn/magic/tangdou.png";
    private static final String TOUTIAO_ICON = "https://yun.duiba.com.cn/magic/toutiao.png";
    public static final UnknownSpider SPIDER = new UnknownSpider();

    private UnknownSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.UNKNOWN;
    }

    @Override
    public DefaultDto unitedStatesSmash(AbstractSpider.RequestParam param) {
        Document document = this.doRequestDocument(param);
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), this.getContentSource().getCode());
        defaultDto.setPostTitle(document.title());
        defaultDto.setSourceId(UUIDUtils.createUUID());
        defaultDto.setImageList(Lists.newArrayList());
        defaultDto.getImageList().add(this.getIconByHost(param.getUrl()));
        if (StringUtils.isBlank((String)defaultDto.getPostTitle())) {
            defaultDto.setPostTitle(param.getUrl());
        }
        return defaultDto;
    }

    @Override
    protected void checkHost(String url) {
    }

    private String getIconByHost(String url) {
        String host = StringUtils.splitByWholeSeparator((String)url, (String)"?")[0];
        if (StringUtils.containsIgnoreCase((String)host, (String)"ixigua.com")) {
            return IXIGUA_ICON;
        }
        if (StringUtils.containsIgnoreCase((String)host, (String)"zhihu.com")) {
            return ZHIHU_ICON;
        }
        if (StringUtils.containsIgnoreCase((String)host, (String)"tangdou.com")) {
            return TANGDOU_ICON;
        }
        if (StringUtils.containsIgnoreCase((String)host, (String)"toutiao.com")) {
            return TOUTIAO_ICON;
        }
        return DEFAULT_ICON;
    }

    public static void main(String[] args) {
        DefaultDto defaultDto = ContentSource.UNKNOWN.getSpider().unitedStatesSmash(new AbstractSpider.RequestParam("https://zhuanlan.zhihu.com/p/69219211"));
        System.err.println(JSON.toJSONString((Object)defaultDto));
    }
}

