/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.spider;

import cn.com.duiba.spider.util.maiquan.Constant.ContentSource;
import cn.com.duiba.spider.util.maiquan.ImageUtil;
import cn.com.duiba.spider.util.maiquan.dto.DefaultDto;
import cn.com.duiba.spider.util.maiquan.spider.AbstractSpider;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class XinLangSpider
extends AbstractSpider {
    public static final XinLangSpider SPIDER = new XinLangSpider();

    private XinLangSpider() {
    }

    @Override
    protected ContentSource getContentSource() {
        return ContentSource.XINLANGTUPIAN;
    }

    @Override
    public DefaultDto unitedStatesSmash(AbstractSpider.RequestParam param) {
        Document document = this.doRequestDocument(param);
        Element body = document.body();
        Elements eData = body.select("div").select("#eData");
        if (eData == null || eData.isEmpty()) {
            return null;
        }
        Elements dls = eData.select("dl");
        if (dls == null || dls.isEmpty()) {
            return null;
        }
        ArrayList imgUrls = Lists.newArrayList();
        dls.forEach(dl -> {
            Element dd = (Element)dl.select("dd").get(0);
            String imgUrl = dd.text();
            imgUrls.add(imgUrl);
        });
        DefaultDto defaultDto = new DefaultDto(param.getUrl(), ContentSource.XINLANGTUPIAN.getCode());
        String[] strings = StringUtils.splitByWholeSeparator((String)param.getUrl(), (String)"/");
        String sid = strings[strings.length - 1];
        defaultDto.setSourceId(sid);
        String title = ((Element)dls.get(0)).select("dt").text();
        defaultDto.setSourceAbstract(title);
        defaultDto.setPostTitle(title);
        defaultDto.setImages(ImageUtil.listByUrls(imgUrls));
        defaultDto.setImageList(imgUrls);
        defaultDto.setContentType("0");
        defaultDto.setAuthor(new DefaultDto.Author("\u65b0\u6d6a\u56fe\u7247", "http://n.sinaimg.cn/sinanews/eb9bf575/20190108/TouXiang120.png"));
        return defaultDto;
    }

    @Override
    protected void checkHost(String url) {
    }

    public static void main(String[] args) {
        DefaultDto defaultDto = ContentSource.XINLANGTUPIAN.getSpider().unitedStatesSmash(new AbstractSpider.RequestParam("http://slide.ent.sina.com.cn/y/slide_4_704_315415.html"));
        System.err.println(JSON.toJSONString((Object)defaultDto));
    }
}

