/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.tts.baidu.common;

import cn.com.duiba.spider.util.maiquan.tts.baidu.common.ConnUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;

public class TokenHolder {
    public static final String ASR_SCOPE = "audio_voice_assistant_get";
    public static final String TTS_SCOPE = "audio_tts_post";
    private static final String URL = "http://openapi.baidu.com/oauth/2.0/token";
    private String scope;
    private String apiKey;
    private String secretKey;
    private String token;
    private long expiresAt;

    public TokenHolder(String apiKey, String secretKey, String scope) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.scope = scope;
    }

    public String getToken() {
        return this.token;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public String refresh() throws IOException {
        if (StringUtils.isNotBlank((String)this.token) && System.currentTimeMillis() - this.expiresAt > 300000L) {
            return this.token;
        }
        String getTokenURL = "http://openapi.baidu.com/oauth/2.0/token?grant_type=client_credentials&client_id=" + ConnUtil.urlEncode(this.apiKey) + "&client_secret=" + ConnUtil.urlEncode(this.secretKey);
        String result = Jsoup.connect((String)getTokenURL).ignoreHttpErrors(true).ignoreContentType(true).timeout(10000).execute().body();
        this.parseJson(result);
        return this.token;
    }

    private void parseJson(String result) {
        JSONObject json = JSON.parseObject((String)result);
        if (!json.containsKey((Object)"access_token")) {
            throw new NullPointerException("access_token not obtained, " + result);
        }
        this.token = json.getString("access_token");
        this.expiresAt = System.currentTimeMillis() + json.getLong("expires_in") * 1000L;
    }
}

