/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.tts.baidu.keyword;

import cn.com.duiba.spider.util.maiquan.tts.baidu.common.TokenHolder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class BaiduKeywordUtil {
    private static final String API_URL = "https://aip.baidubce.com/rpc/2.0/nlp/v1/keyword?charset=UTF-8&access_token=%s";
    private static final TokenHolder TOKEN_HOLDER = new TokenHolder("NG08AwHezOTKpXUcQAzeSkw5", "KLDuiOMg6f60mw7s5eXm8LjxPwHrkjGK", "");

    public static Tags tag4Text(String title, String content) throws IOException {
        if (StringUtils.isBlank((String)title) || StringUtils.isBlank((String)content)) {
            return new Tags(Lists.newArrayList(), Lists.newArrayList());
        }
        TextReq textReq = new TextReq(title, content);
        String body = Jsoup.connect((String)String.format(API_URL, TOKEN_HOLDER.refresh())).ignoreContentType(true).ignoreHttpErrors(true).requestBody(JSON.toJSONString((Object)textReq)).method(Connection.Method.POST).timeout(5000).execute().body();
        JSONObject result = JSON.parseObject((String)body);
        if (result == null || !result.containsKey((Object)"items")) {
            return new Tags(Lists.newArrayList(), Lists.newArrayList());
        }
        JSONArray items = result.getJSONArray("items");
        ArrayList tags = Lists.newArrayList();
        List<Keyword> keywords = items.stream().map(i -> {
            Keyword keyword = (Keyword)JSON.parseObject((String)i.toString(), Keyword.class);
            tags.add(keyword.getTag());
            return keyword;
        }).collect(Collectors.toList());
        return new Tags(tags, keywords);
    }

    public static void main(String[] args) throws IOException {
        Tags tags = BaiduKeywordUtil.tag4Text("iphone\u624b\u673a\u51fa\u73b0\u201c\u767d\u82f9\u679c\u201d\u539f\u56e0\u53ca\u89e3\u51b3\u529e\u6cd5\uff0c\u7528\u82f9\u679c\u624b\u673a\u7684\u53ef\u4ee5\u770b\u4e0b", "\u5982\u679c\u4e0b\u9762\u7684\u65b9\u6cd5\u8fd8\u662f\u6ca1\u6709\u89e3\u51b3\u4f60\u7684\u95ee\u9898\u5efa\u8bae\u6765\u6211\u4eec\u95e8\u5e97\u770b\u4e0b\u6210\u90fd\u5e02\u9526\u6c5f\u533a\u7ea2\u661f\u8def\u4e09\u6bb599\u53f7\u94f6\u77f3\u5e7f\u573a24\u5c4201\u5ba4\u3002\u5728\u901a\u7535\u7684\u60c5\u51b5\u4e0b\u6389\u8fdb\u6e05\u6c34\uff0c\u8fd9\u79cd\u60c5\u51b5\u4e00\u4e0d\u9700\u8981\u62c6\u673a\u5904\u7406\u3002\u5c3d\u5feb\u65ad\u7535\u3002\u7528\u529b\u7529\u5e72\uff0c\u4f46\u522b\u628a\u673a\u5668\u7529\u6389\uff0c\u4e3b\u610f\u8981\u628a\u5c4f\u5e55\u5185\u7684\u6c34\u7529\u51fa\u6765\u3002\u5982\u679c\u5c4f\u5e55\u6b8b\u7559\u6709\u6c34\u6ef4\uff0c\u5e72\u540e\u4f1a\u6709\u75d5\u8ff9\u3002^H3 \u653e\u5728\u53f0\u706f\uff0c\u5c04\u706f\u7b49\u8f7b\u5fae\u70ed\u6e90\u4e0b\u8ba9\u6c34\u5206\u6162\u6162\u6563\u53bb\u3002");
        System.err.println(JSON.toJSONString((Object)tags));
    }

    public static class Keyword {
        private String score;
        private String tag;

        public String getScore() {
            return this.score;
        }

        public void setScore(String score) {
            this.score = score;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }

    public static class Tags {
        private List<String> tags;
        private List<Keyword> keywords;

        public Tags(List<String> tags, List<Keyword> keywords) {
            this.tags = tags;
            this.keywords = keywords;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public List<Keyword> getKeywords() {
            return this.keywords;
        }

        public void setKeywords(List<Keyword> keywords) {
            this.keywords = keywords;
        }
    }

    static class TextReq {
        private String title;
        private String content;

        public TextReq(String title, String content) {
            this.title = title;
            this.content = content;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}

